/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import org.controlsfx.control.action.Action;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportCommand
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportCommand.class);
    private final ExportMethod exportMethod;
    private final Supplier<LibraryTab> tabSupplier;
    private final StateManager stateManager;
    private final PreferencesService preferences;
    private final DialogService dialogService;
    private final BibEntryTypesManager entryTypesManager;
    private final JournalAbbreviationRepository abbreviationRepository;
    private final TaskExecutor taskExecutor;

    public ExportCommand(ExportMethod exportMethod, Supplier<LibraryTab> tabSupplier, StateManager stateManager, DialogService dialogService, PreferencesService preferences, BibEntryTypesManager entryTypesManager, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor) {
        this.exportMethod = exportMethod;
        this.tabSupplier = tabSupplier;
        this.stateManager = stateManager;
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.entryTypesManager = entryTypesManager;
        this.abbreviationRepository = abbreviationRepository;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)(exportMethod == ExportMethod.EXPORT_SELECTED ? ActionHelper.needsEntriesSelected(stateManager) : ActionHelper.needsDatabase(stateManager)));
    }

    public void execute() {
        ExporterFactory exporterFactory = ExporterFactory.create(this.preferences, this.entryTypesManager);
        List<Exporter> exporters = exporterFactory.getExporters().stream().sorted(Comparator.comparing(Exporter::getName)).collect(Collectors.toList());
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(FileFilterConverter.exporterToExtensionFilter(exporters)).withDefaultExtension(this.preferences.getExportPreferences().getLastExportExtension()).withInitialDirectory(this.preferences.getExportPreferences().getExportWorkingDirectory()).build();
        this.dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(path -> this.export((Path)path, fileDialogConfiguration.getSelectedExtensionFilter(), exporters));
    }

    private void export(Path file, FileChooser.ExtensionFilter selectedExtensionFilter, List<Exporter> exporters) {
        String selectedExtension = ((String)selectedExtensionFilter.getExtensions().getFirst()).replace("*", "");
        if (!file.endsWith(selectedExtension)) {
            FileUtil.addExtension(file, selectedExtension);
        }
        Exporter format = FileFilterConverter.getExporter(selectedExtensionFilter, exporters).orElseThrow(() -> new IllegalStateException("User didn't selected a file type for the extension"));
        Object entries = this.exportMethod == ExportMethod.EXPORT_SELECTED ? this.stateManager.getSelectedEntries() : this.stateManager.getActiveDatabase().map(BibDatabaseContext::getEntries).orElse(Collections.emptyList());
        List<Path> fileDirForDatabase = this.stateManager.getActiveDatabase().map(db -> db.getFileDirectories(this.preferences.getFilePreferences())).orElse(List.of(this.preferences.getFilePreferences().getWorkingDirectory()));
        this.preferences.getExportPreferences().setLastExportExtension(format.getName());
        this.preferences.getExportPreferences().setExportWorkingDirectory(file.getParent());
        Object finEntries = entries;
        BackgroundTask.wrap(() -> {
            format.export(this.stateManager.getActiveDatabase().get(), file, (List<BibEntry>)finEntries, fileDirForDatabase, this.abbreviationRepository);
            return null;
        }).onSuccess(save -> {
            LibraryTab.DatabaseNotification notificationPane = this.tabSupplier.get().getNotificationPane();
            notificationPane.notify(IconTheme.JabRefIcons.FOLDER.getGraphicNode(), Localization.lang("Export operation finished successfully.", new Object[0]), List.of(new Action(Localization.lang("Reveal in File Explorer", new Object[0]), event -> {
                try {
                    JabRefDesktop.openFolderAndSelectFile(file, this.preferences.getExternalApplicationsPreferences(), this.dialogService);
                }
                catch (IOException e) {
                    LOGGER.error("Could not open export folder.", (Throwable)e);
                }
                notificationPane.hide();
            })), Duration.seconds((double)5.0));
        }).onFailure(this::handleError).executeWith(this.taskExecutor);
    }

    private void handleError(Exception ex) {
        LOGGER.warn("Problem exporting", (Throwable)ex);
        this.dialogService.notify(Localization.lang("Could not save file.", new Object[0]));
        this.dialogService.showErrorDialogAndWait(Localization.lang("Save library", new Object[0]), Localization.lang("Could not save file.", new Object[0]), ex);
    }

    public static enum ExportMethod {
        EXPORT_ALL,
        EXPORT_SELECTED;

    }
}

