/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UserSpecificCommentField;
import org.jabref.preferences.PreferencesService;

public class OtherFieldsTab
extends FieldsEditorTab {
    public static final String NAME = "Other fields";
    private final List<Field> customTabsFieldNames;
    private final BibEntryTypesManager entryTypesManager;

    public OtherFieldsTab(BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        super(false, databaseContext, suggestionProviders, undoManager, undoAction, redoAction, dialogService, preferences, stateManager, themeManager, taskExecutor, journalAbbreviationRepository, indexingTaskManager);
        this.entryTypesManager = entryTypesManager;
        this.customTabsFieldNames = new ArrayList<Field>();
        preferences.getEntryEditorPreferences().getEntryEditorTabs().values().forEach(this.customTabsFieldNames::addAll);
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show remaining fields", new Object[0])));
        this.setGraphic(IconTheme.JabRefIcons.OPTIONAL.getGraphicNode());
    }

    @Override
    protected SequencedSet<Field> determineFieldsToShow(BibEntry entry) {
        BibDatabaseMode mode = this.databaseContext.getMode();
        Optional<BibEntryType> entryType = this.entryTypesManager.enrich(entry.getType(), mode);
        if (entryType.isPresent()) {
            Set<Field> allKnownFields = entryType.get().getAllFields();
            SequencedSet otherFields = entry.getFields().stream().filter(field -> !allKnownFields.contains(field)).collect(Collectors.toCollection(LinkedHashSet::new));
            otherFields.remove(InternalField.KEY_FIELD);
            otherFields.removeAll(entryType.get().getDeprecatedFields(mode));
            this.customTabsFieldNames.forEach(otherFields::remove);
            otherFields.removeIf(field -> field.equals(StandardField.COMMENT));
            otherFields.removeIf(field -> field instanceof UserSpecificCommentField);
            return otherFields;
        }
        return new LinkedHashSet<Field>();
    }
}

