/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.Optional;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.WebViewStore;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.MathSciNetId;

public class MathSciNetTab
extends EntryEditorTab {
    public static final String NAME = "MathSciNet Review";

    public MathSciNetTab() {
        this.setText(Localization.lang(NAME, new Object[0]));
    }

    private Optional<MathSciNetId> getMathSciNetId(BibEntry entry) {
        return entry.getField(StandardField.MR_NUMBER).flatMap(MathSciNetId::parse);
    }

    private StackPane getPane(BibEntry entry) {
        StackPane root = new StackPane();
        ProgressIndicator progress = new ProgressIndicator();
        progress.setMaxSize(100.0, 100.0);
        WebView browser = WebViewStore.get();
        browser.addEventFilter(MouseEvent.ANY, Event::consume);
        browser.setContextMenuEnabled(false);
        root.getChildren().addAll((Object[])new Node[]{browser, progress});
        Optional<MathSciNetId> mathSciNetId = this.getMathSciNetId(entry);
        mathSciNetId.flatMap(MathSciNetId::getExternalURI).ifPresent(url -> browser.getEngine().load(url.toASCIIString()));
        browser.getEngine().getLoadWorker().progressProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.doubleValue() >= 0.7) {
                progress.setVisible(false);
            }
        });
        return root;
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return this.getMathSciNetId(entry).isPresent();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        this.setContent((Node)this.getPane(entry));
    }
}

