/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.edit.ReplaceStringViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.logic.l10n.Localization;

public class ReplaceStringView
extends BaseDialog<Void> {
    @FXML
    private RadioButton allReplace;
    @FXML
    private CheckBox selectFieldOnly;
    @FXML
    private ButtonType replaceButton;
    @FXML
    private TextField limitFieldInput;
    @FXML
    private TextField findField;
    @FXML
    private TextField replaceField;
    private ReplaceStringViewModel viewModel;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public ReplaceStringView(LibraryTab libraryTab) {
        this.setTitle(Localization.lang("Replace String", new Object[0]));
        this.viewModel = new ReplaceStringViewModel(libraryTab);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.replaceButton, this.getDialogPane(), event -> this.buttonReplace());
    }

    @FXML
    public void initialize() {
        this.visualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.viewModel.findStringProperty().bind((ObservableValue)this.findField.textProperty());
        this.viewModel.replaceStringProperty().bind((ObservableValue)this.replaceField.textProperty());
        this.viewModel.fieldStringProperty().bind((ObservableValue)this.limitFieldInput.textProperty());
        this.viewModel.selectOnlyProperty().bind((ObservableValue)this.selectFieldOnly.selectedProperty());
        this.viewModel.allFieldReplaceProperty().bind((ObservableValue)this.allReplace.selectedProperty());
    }

    @FXML
    private void buttonReplace() {
        String findString = this.findField.getText();
        if ("".equals(findString)) {
            this.close();
            return;
        }
        this.viewModel.replace();
        this.close();
    }
}

