/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import com.tobiasdiez.easybind.EasyBind;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.edit.ManageKeywordsDisplayType;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.preferences.BibEntryPreferences;

public class ManageKeywordsViewModel {
    private final List<BibEntry> entries;
    private final KeywordList sortedKeywordsOfAllEntriesBeforeUpdateByUser = new KeywordList();
    private final BibEntryPreferences bibEntryPreferences;
    private final ObjectProperty<ManageKeywordsDisplayType> displayType = new SimpleObjectProperty((Object)ManageKeywordsDisplayType.CONTAINED_IN_ALL_ENTRIES);
    private final ObservableList<String> keywords;

    public ManageKeywordsViewModel(BibEntryPreferences bibEntryPreferences, List<BibEntry> entries) {
        this.bibEntryPreferences = bibEntryPreferences;
        this.entries = entries;
        this.keywords = FXCollections.observableArrayList();
        EasyBind.subscribe(this.displayType, this::fillKeywordsList);
    }

    public ManageKeywordsDisplayType getDisplayType() {
        return (ManageKeywordsDisplayType)((Object)this.displayType.get());
    }

    public ObjectProperty<ManageKeywordsDisplayType> displayTypeProperty() {
        return this.displayType;
    }

    private void fillKeywordsList(ManageKeywordsDisplayType type) {
        this.keywords.clear();
        this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.clear();
        Character keywordSeparator = this.bibEntryPreferences.getKeywordSeparator();
        if (type == ManageKeywordsDisplayType.CONTAINED_IN_ALL_ENTRIES) {
            for (BibEntry entry : this.entries) {
                KeywordList separatedKeywords = entry.getKeywords(keywordSeparator);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            }
        } else if (type == ManageKeywordsDisplayType.CONTAINED_IN_ANY_ENTRY) {
            BibEntry firstEntry = this.entries.getFirst();
            KeywordList separatedKeywords = firstEntry.getKeywords(keywordSeparator);
            this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            for (BibEntry entry : this.entries) {
                separatedKeywords = entry.getKeywords(keywordSeparator);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.retainAll(separatedKeywords);
            }
        } else {
            throw new IllegalStateException("DisplayType " + String.valueOf((Object)type) + " not handled");
        }
        for (Keyword keyword : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            this.keywords.add((Object)keyword.get());
        }
    }

    public ObservableList<String> getKeywords() {
        return this.keywords;
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove((Object)keyword);
    }

    public void saveChanges() {
        KeywordList keywordsToAdd = new KeywordList();
        KeywordList userSelectedKeywords = new KeywordList();
        for (Object keyword : this.keywords) {
            userSelectedKeywords.add((String)keyword);
            if (this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.contains((String)keyword)) continue;
            keywordsToAdd.add((String)keyword);
        }
        KeywordList keywordsToRemove = new KeywordList();
        for (Keyword kword : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            if (userSelectedKeywords.contains(kword)) continue;
            keywordsToRemove.add(kword);
        }
        if (keywordsToAdd.isEmpty() && keywordsToRemove.isEmpty()) {
            return;
        }
        NamedCompound ce = this.updateKeywords(this.entries, keywordsToAdd, keywordsToRemove);
    }

    private NamedCompound updateKeywords(List<BibEntry> entries, KeywordList keywordsToAdd, KeywordList keywordsToRemove) {
        Character keywordSeparator = this.bibEntryPreferences.getKeywordSeparator();
        NamedCompound ce = new NamedCompound(Localization.lang("Update keywords", new Object[0]));
        for (BibEntry entry : entries) {
            KeywordList keywords = entry.getKeywords(keywordSeparator);
            keywords.removeAll(keywordsToRemove);
            keywords.addAll(keywordsToAdd);
            Optional<FieldChange> change = entry.putKeywords(keywords, keywordSeparator);
            change.ifPresent(fieldChange -> ce.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
        }
        ce.end();
        return ce;
    }
}

