/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.duplicationFinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.duplicationFinder.DuplicateResolverDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertEntries;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public class DuplicateSearch
extends SimpleCommand {
    private final Supplier<LibraryTab> tabSupplier;
    private final BlockingQueue<List<BibEntry>> duplicates = new LinkedBlockingQueue<List<BibEntry>>();
    private final AtomicBoolean libraryAnalyzed = new AtomicBoolean();
    private final AtomicBoolean autoRemoveExactDuplicates = new AtomicBoolean();
    private final AtomicInteger duplicateCount = new AtomicInteger();
    private final SimpleStringProperty duplicateCountObservable = new SimpleStringProperty();
    private final SimpleStringProperty duplicateTotal = new SimpleStringProperty();
    private final SimpleIntegerProperty duplicateProgress = new SimpleIntegerProperty(0);
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService prefs;
    private final BibEntryTypesManager entryTypesManager;
    private final TaskExecutor taskExecutor;

    public DuplicateSearch(Supplier<LibraryTab> tabSupplier, DialogService dialogService, StateManager stateManager, PreferencesService prefs, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor) {
        this.tabSupplier = tabSupplier;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.prefs = prefs;
        this.entryTypesManager = entryTypesManager;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public void execute() {
        BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        this.dialogService.notify(Localization.lang("Searching for duplicates...", new Object[0]));
        List<BibEntry> entries = database.getEntries();
        this.duplicates.clear();
        this.libraryAnalyzed.set(false);
        this.autoRemoveExactDuplicates.set(false);
        this.duplicateCount.set(0);
        if (entries.size() < 2) {
            return;
        }
        this.duplicateCountObservable.addListener((obj, oldValue, newValue) -> UiTaskExecutor.runAndWaitInJavaFXThread(() -> this.duplicateTotal.set(newValue)));
        HeadlessExecutorService.INSTANCE.executeInterruptableTask(() -> this.searchPossibleDuplicates(entries, database.getMode()), "DuplicateSearcher");
        BackgroundTask.wrap(this::verifyDuplicates).onSuccess(this::handleDuplicates).executeWith(this.taskExecutor);
    }

    private void searchPossibleDuplicates(List<BibEntry> entries, BibDatabaseMode databaseMode) {
        for (int i = 0; i < entries.size() - 1; ++i) {
            for (int j = i + 1; j < entries.size(); ++j) {
                BibEntry second;
                if (Thread.interrupted()) {
                    return;
                }
                BibEntry first = entries.get(i);
                if (!new DuplicateCheck(this.entryTypesManager).isDuplicate(first, second = entries.get(j), databaseMode)) continue;
                this.duplicates.add(Arrays.asList(first, second));
                this.duplicateCountObservable.set(String.valueOf(this.duplicateCount.incrementAndGet()));
            }
        }
        this.libraryAnalyzed.set(true);
    }

    private DuplicateSearchResult verifyDuplicates() {
        DuplicateSearchResult result = new DuplicateSearchResult();
        while (!this.libraryAnalyzed.get() || !this.duplicates.isEmpty()) {
            List<BibEntry> dups;
            this.duplicateProgress.set(this.duplicateProgress.getValue() + 1);
            try {
                dups = this.duplicates.poll(100L, TimeUnit.MILLISECONDS);
                if (dups == null) {
                    continue;
                }
            }
            catch (InterruptedException e) {
                return null;
            }
            BibEntry first = dups.getFirst();
            BibEntry second = dups.get(1);
            if (result.isToRemove(first) || result.isToRemove(second)) continue;
            boolean askAboutExact = false;
            if (DuplicateCheck.compareEntriesStrictly(first, second) > 1.0) {
                if (this.autoRemoveExactDuplicates.get()) {
                    result.remove(second);
                    continue;
                }
                askAboutExact = true;
            }
            DuplicateResolverDialog.DuplicateResolverType resolverType = askAboutExact ? DuplicateResolverDialog.DuplicateResolverType.DUPLICATE_SEARCH_WITH_EXACT : DuplicateResolverDialog.DuplicateResolverType.DUPLICATE_SEARCH;
            UiTaskExecutor.runAndWaitInJavaFXThread(() -> this.askResolveStrategy(result, first, second, resolverType));
        }
        return result;
    }

    private void askResolveStrategy(DuplicateSearchResult result, BibEntry first, BibEntry second, DuplicateResolverDialog.DuplicateResolverType resolverType) {
        DuplicateResolverDialog dialog = new DuplicateResolverDialog(first, second, resolverType, this.tabSupplier.get().getBibDatabaseContext(), this.stateManager, this.dialogService, this.prefs);
        dialog.titleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{dialog.getTitle()}).concat((Object)" (").concat((Object)this.duplicateProgress.getValue()).concat((Object)"/").concat((Object)this.duplicateTotal).concat((Object)")"));
        DuplicateResolverDialog.DuplicateResolverResult resolverResult = this.dialogService.showCustomDialogAndWait(dialog).orElse(DuplicateResolverDialog.DuplicateResolverResult.BREAK);
        if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.KEEP_LEFT || resolverResult == DuplicateResolverDialog.DuplicateResolverResult.AUTOREMOVE_EXACT) {
            result.remove(second);
            result.replace(first, dialog.getNewLeftEntry());
            if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.AUTOREMOVE_EXACT) {
                this.autoRemoveExactDuplicates.set(true);
            }
        } else if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.KEEP_RIGHT) {
            result.remove(first);
            result.replace(second, dialog.getNewRightEntry());
        } else if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.BREAK) {
            this.libraryAnalyzed.set(true);
            this.duplicates.clear();
        } else if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.KEEP_MERGE) {
            result.replace(first, second, dialog.getMergedEntry());
        } else if (resolverResult == DuplicateResolverDialog.DuplicateResolverResult.KEEP_BOTH) {
            result.replace(first, dialog.getNewLeftEntry());
            result.replace(second, dialog.getNewRightEntry());
        }
    }

    private void handleDuplicates(DuplicateSearchResult result) {
        if (result == null) {
            return;
        }
        LibraryTab libraryTab = this.tabSupplier.get();
        NamedCompound compoundEdit = new NamedCompound(Localization.lang("duplicate removal", new Object[0]));
        if (!result.getToRemove().isEmpty()) {
            compoundEdit.addEdit(new UndoableRemoveEntries(libraryTab.getDatabase(), result.getToRemove()));
            libraryTab.getDatabase().removeEntries(result.getToRemove());
            libraryTab.markBaseChanged();
        }
        if (!result.getToAdd().isEmpty()) {
            compoundEdit.addEdit(new UndoableInsertEntries(libraryTab.getDatabase(), result.getToAdd()));
            libraryTab.getDatabase().insertEntries(result.getToAdd());
            libraryTab.markBaseChanged();
        }
        this.duplicateProgress.set(0);
        this.dialogService.notify(Localization.lang("Duplicates found", new Object[0]) + ": " + this.duplicateCount.get() + " " + Localization.lang("pairs processed", new Object[0]) + ": " + result.getDuplicateCount());
        compoundEdit.end();
        libraryTab.getUndoManager().addEdit(compoundEdit);
    }

    static class DuplicateSearchResult {
        private final Map<Integer, BibEntry> toRemove = new HashMap<Integer, BibEntry>();
        private final List<BibEntry> toAdd = new ArrayList<BibEntry>();
        private int duplicates = 0;

        DuplicateSearchResult() {
        }

        public synchronized List<BibEntry> getToRemove() {
            return new ArrayList<BibEntry>(this.toRemove.values());
        }

        public synchronized List<BibEntry> getToAdd() {
            return this.toAdd;
        }

        public synchronized void remove(BibEntry entry) {
            this.toRemove.put(System.identityHashCode(entry), entry);
            ++this.duplicates;
        }

        public synchronized void replace(BibEntry first, BibEntry second, BibEntry replacement) {
            this.remove(first);
            this.remove(second);
            this.toAdd.add(replacement);
            ++this.duplicates;
        }

        public synchronized void replace(BibEntry entry, BibEntry replacement) {
            this.remove(entry);
            this.getToAdd().add(replacement);
        }

        public synchronized boolean isToRemove(BibEntry entry) {
            return this.toRemove.containsKey(System.identityHashCode(entry));
        }

        public synchronized int getDuplicateCount() {
            return this.duplicates;
        }
    }
}

