/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import com.tobiasdiez.easybind.EasyBind;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.StateManager;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.PdfDocumentViewModel;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentViewerViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentViewerViewModel.class);
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final ObjectProperty<DocumentViewModel> currentDocument = new SimpleObjectProperty();
    private final ListProperty<LinkedFile> files = new SimpleListProperty();
    private final BooleanProperty liveMode = new SimpleBooleanProperty(true);
    private final ObjectProperty<Integer> currentPage = new SimpleObjectProperty();
    private final IntegerProperty maxPages = new SimpleIntegerProperty();

    public DocumentViewerViewModel(StateManager stateManager, PreferencesService preferencesService) {
        this.stateManager = Objects.requireNonNull(stateManager);
        this.preferencesService = Objects.requireNonNull(preferencesService);
        this.stateManager.getSelectedEntries().addListener(c -> {
            if (this.liveMode.get()) {
                this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
            }
        });
        this.liveMode.addListener((observable, oldValue, newValue) -> {
            if (oldValue != newValue && newValue.booleanValue()) {
                this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
            }
        });
        UiTaskExecutor.runInJavaFXThread(() -> this.maxPages.bind((ObservableValue)EasyBind.wrapNullable(this.currentDocument).selectProperty(DocumentViewModel::maxPagesProperty)));
        this.setCurrentEntries((List<BibEntry>)this.stateManager.getSelectedEntries());
    }

    private int getCurrentPage() {
        return (Integer)this.currentPage.get();
    }

    public ObjectProperty<Integer> currentPageProperty() {
        return this.currentPage;
    }

    public IntegerProperty maxPagesProperty() {
        return this.maxPages;
    }

    public ObjectProperty<DocumentViewModel> currentDocumentProperty() {
        return this.currentDocument;
    }

    public ListProperty<LinkedFile> filesProperty() {
        return this.files;
    }

    private void setCurrentEntries(List<BibEntry> entries) {
        if (entries.isEmpty()) {
            this.files.clear();
        } else {
            Set linkedFiles = entries.stream().map(BibEntry::getFiles).flatMap(Collection::stream).collect(Collectors.toSet());
            this.files.setValue(FXCollections.observableArrayList(linkedFiles));
        }
    }

    private void setCurrentDocument(Path path) {
        try {
            if (FileUtil.isPDFFile(path)) {
                PDDocument document = Loader.loadPDF((File)path.toFile());
                this.currentDocument.set((Object)new PdfDocumentViewModel(document));
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not set Document Viewer for path {}", (Object)path, (Object)e);
        }
    }

    public void switchToFile(LinkedFile file) {
        if (file != null) {
            this.stateManager.getActiveDatabase().flatMap(database -> file.findIn((BibDatabaseContext)database, this.preferencesService.getFilePreferences())).ifPresent(this::setCurrentDocument);
            this.currentPage.set((Object)1);
        }
    }

    public void showPage(int pageNumber) {
        if (pageNumber >= 1 && pageNumber <= this.maxPages.get()) {
            this.currentPage.set((Object)pageNumber);
        } else {
            this.currentPage.set((Object)1);
        }
    }

    public void showNextPage() {
        if (this.getCurrentPage() < this.maxPages.get()) {
            this.currentPage.set((Object)(this.getCurrentPage() + 1));
        }
    }

    public void showPreviousPage() {
        if (this.getCurrentPage() > 1) {
            this.currentPage.set((Object)(this.getCurrentPage() - 1));
        }
    }

    public void setLiveMode(boolean value) {
        this.liveMode.set(value);
    }
}

