/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.entrychange;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.collab.DatabaseChangeDetailsView;
import org.jabref.gui.collab.entrychange.PreviewWithSourceTab;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public final class EntryChangeDetailsView
extends DatabaseChangeDetailsView {
    private final PreviewWithSourceTab oldPreviewWithSourcesTab = new PreviewWithSourceTab();
    private final PreviewWithSourceTab newPreviewWithSourcesTab = new PreviewWithSourceTab();
    private boolean scrolling = false;

    public EntryChangeDetailsView(BibEntry oldEntry, BibEntry newEntry, BibDatabaseContext databaseContext, DialogService dialogService, StateManager stateManager, ThemeManager themeManager, PreferencesService preferencesService, BibEntryTypesManager entryTypesManager, PreviewViewer previewViewer, TaskExecutor taskExecutor) {
        Label inJabRef = new Label(Localization.lang("In JabRef", new Object[0]));
        inJabRef.getStyleClass().add((Object)"lib-change-header");
        Label onDisk = new Label(Localization.lang("On disk", new Object[0]));
        onDisk.getStyleClass().add((Object)"lib-change-header");
        PreviewViewer previewClone = new PreviewViewer(databaseContext, dialogService, preferencesService, stateManager, themeManager, taskExecutor);
        WebView previewCloneView = (WebView)previewClone.getContent();
        WebView previewViewerView = (WebView)previewViewer.getContent();
        this.synchronizeScrolling(previewCloneView, previewViewerView);
        this.synchronizeScrolling(previewViewerView, previewCloneView);
        TabPane oldEntryTabPane = this.oldPreviewWithSourcesTab.getPreviewWithSourceTab(oldEntry, databaseContext, preferencesService, entryTypesManager, previewClone, Localization.lang("Entry Preview", new Object[0]));
        TabPane newEntryTabPane = this.newPreviewWithSourcesTab.getPreviewWithSourceTab(newEntry, databaseContext, preferencesService, entryTypesManager, previewViewer, Localization.lang("Entry Preview", new Object[0]));
        EasyBind.subscribe((ObservableValue)oldEntryTabPane.getSelectionModel().selectedIndexProperty(), selectedIndex -> newEntryTabPane.getSelectionModel().select(selectedIndex.intValue()));
        EasyBind.subscribe((ObservableValue)newEntryTabPane.getSelectionModel().selectedIndexProperty(), selectedIndex -> {
            if (oldEntryTabPane.getSelectionModel().getSelectedIndex() != selectedIndex.intValue()) {
                oldEntryTabPane.getSelectionModel().select(selectedIndex.intValue());
            }
        });
        VBox containerOld = new VBox(new Node[]{inJabRef, oldEntryTabPane});
        VBox containerNew = new VBox(new Node[]{onDisk, newEntryTabPane});
        SplitPane split = new SplitPane(new Node[]{containerOld, containerNew});
        split.setOrientation(Orientation.HORIZONTAL);
        this.setAllAnchorsAndAttachChild((Node)split);
    }

    private void synchronizeScrolling(WebView webView, WebView otherWebView) {
        webView.addEventHandler(Event.ANY, event -> {
            if (!this.scrolling) {
                this.scrolling = true;
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    if (mouseEvent.isPrimaryButtonDown()) {
                        int value = (Integer)webView.getEngine().executeScript("window.scrollY");
                        otherWebView.getEngine().executeScript("window.scrollTo(0, " + value + ")");
                    }
                } else {
                    otherWebView.fireEvent(event.copyFor((Object)otherWebView, (EventTarget)otherWebView));
                }
                this.scrolling = false;
            }
        });
    }
}

