/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import com.airhacks.afterburner.views.ViewLoader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.jabref.gui.commonfxcontrols.FieldFormatterCleanupsPanel;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.FilePreferences;

public class CleanupPresetPanel
extends VBox {
    private final BibDatabaseContext databaseContext;
    @FXML
    private Label cleanupRenamePDFLabel;
    @FXML
    private CheckBox cleanUpDOI;
    @FXML
    private CheckBox cleanUpEprint;
    @FXML
    private CheckBox cleanUpURL;
    @FXML
    private CheckBox cleanUpISSN;
    @FXML
    private CheckBox cleanUpMovePDF;
    @FXML
    private CheckBox cleanUpMakePathsRelative;
    @FXML
    private CheckBox cleanUpRenamePDF;
    @FXML
    private CheckBox cleanUpRenamePDFonlyRelativePaths;
    @FXML
    private CheckBox cleanUpDeletedFiles;
    @FXML
    private CheckBox cleanUpUpgradeExternalLinks;
    @FXML
    private CheckBox cleanUpBiblatex;
    @FXML
    private CheckBox cleanUpBibtex;
    @FXML
    private CheckBox cleanUpTimestampToCreationDate;
    @FXML
    private CheckBox cleanUpTimestampToModificationDate;
    @FXML
    private FieldFormatterCleanupsPanel formatterCleanupsPanel;

    public CleanupPresetPanel(BibDatabaseContext databaseContext, CleanupPreferences cleanupPreferences, FilePreferences filePreferences) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
        this.init(cleanupPreferences, filePreferences);
    }

    private void init(CleanupPreferences cleanupPreferences, FilePreferences filePreferences) {
        Optional<Path> firstExistingDir = this.databaseContext.getFirstExistingFileDir(filePreferences);
        if (firstExistingDir.isPresent()) {
            this.cleanUpMovePDF.setText(Localization.lang("Move linked files to default file directory %0", firstExistingDir.get().toString()));
        } else {
            this.cleanUpMovePDF.setText(Localization.lang("Move linked files to default file directory %0", "..."));
            this.cleanUpMovePDF.setDisable(true);
            this.cleanUpMovePDF.setSelected(false);
        }
        this.cleanUpRenamePDFonlyRelativePaths.disableProperty().bind((ObservableValue)this.cleanUpRenamePDF.selectedProperty().not());
        this.cleanUpUpgradeExternalLinks.setText(Localization.lang("Upgrade external PDF/PS links to use the '%0' field.", StandardField.FILE.getDisplayName()));
        String currentPattern = Localization.lang("Filename format pattern", new Object[0]).concat(": ").concat(filePreferences.getFileNamePattern());
        this.cleanupRenamePDFLabel.setText(currentPattern);
        this.cleanUpBibtex.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.cleanUpBiblatex.selectedProperty().setValue(Boolean.valueOf(false));
            }
        });
        this.cleanUpBiblatex.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.cleanUpBibtex.selectedProperty().setValue(Boolean.valueOf(false));
            }
        });
        this.cleanUpTimestampToCreationDate.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.cleanUpTimestampToModificationDate.selectedProperty().setValue(Boolean.valueOf(false));
            }
        });
        this.cleanUpTimestampToModificationDate.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.cleanUpTimestampToCreationDate.selectedProperty().setValue(Boolean.valueOf(false));
            }
        });
        this.updateDisplay(cleanupPreferences);
    }

    private void updateDisplay(CleanupPreferences preset) {
        this.cleanUpDOI.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEAN_UP_DOI).booleanValue());
        this.cleanUpEprint.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEANUP_EPRINT).booleanValue());
        this.cleanUpURL.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEAN_UP_URL).booleanValue());
        if (!this.cleanUpMovePDF.isDisabled()) {
            this.cleanUpMovePDF.setSelected(preset.isActive(CleanupPreferences.CleanupStep.MOVE_PDF).booleanValue());
        }
        this.cleanUpMakePathsRelative.setSelected(preset.isActive(CleanupPreferences.CleanupStep.MAKE_PATHS_RELATIVE).booleanValue());
        this.cleanUpRenamePDF.setSelected(preset.isActive(CleanupPreferences.CleanupStep.RENAME_PDF).booleanValue());
        this.cleanUpRenamePDFonlyRelativePaths.setSelected(preset.isActive(CleanupPreferences.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS).booleanValue());
        this.cleanUpUpgradeExternalLinks.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS).booleanValue());
        this.cleanUpDeletedFiles.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEAN_UP_DELETED_LINKED_FILES).booleanValue());
        this.cleanUpBiblatex.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CONVERT_TO_BIBLATEX).booleanValue());
        this.cleanUpBibtex.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CONVERT_TO_BIBTEX).booleanValue());
        this.cleanUpTimestampToCreationDate.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_CREATIONDATE).booleanValue());
        this.cleanUpTimestampToModificationDate.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_MODIFICATIONDATE).booleanValue());
        this.cleanUpTimestampToModificationDate.setSelected(preset.isActive(CleanupPreferences.CleanupStep.DO_NOT_CONVERT_TIMESTAMP).booleanValue());
        this.cleanUpISSN.setSelected(preset.isActive(CleanupPreferences.CleanupStep.CLEAN_UP_ISSN).booleanValue());
        this.formatterCleanupsPanel.cleanupsDisableProperty().setValue(Boolean.valueOf(!preset.getFieldFormatterCleanups().isEnabled()));
        this.formatterCleanupsPanel.cleanupsProperty().setValue(FXCollections.observableArrayList(preset.getFieldFormatterCleanups().getConfiguredActions()));
    }

    public CleanupPreferences getCleanupPreset() {
        EnumSet<CleanupPreferences.CleanupStep> activeJobs = EnumSet.noneOf(CleanupPreferences.CleanupStep.class);
        if (this.cleanUpMovePDF.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.MOVE_PDF);
        }
        if (this.cleanUpDOI.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEAN_UP_DOI);
        }
        if (this.cleanUpEprint.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEANUP_EPRINT);
        }
        if (this.cleanUpURL.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEAN_UP_URL);
        }
        if (this.cleanUpISSN.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEAN_UP_ISSN);
        }
        if (this.cleanUpMakePathsRelative.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.MAKE_PATHS_RELATIVE);
        }
        if (this.cleanUpRenamePDF.isSelected()) {
            if (this.cleanUpRenamePDFonlyRelativePaths.isSelected()) {
                activeJobs.add(CleanupPreferences.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
            } else {
                activeJobs.add(CleanupPreferences.CleanupStep.RENAME_PDF);
            }
        }
        if (this.cleanUpUpgradeExternalLinks.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
        }
        if (this.cleanUpDeletedFiles.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CLEAN_UP_DELETED_LINKED_FILES);
        }
        if (this.cleanUpBiblatex.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CONVERT_TO_BIBLATEX);
        }
        if (this.cleanUpBibtex.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CONVERT_TO_BIBTEX);
        }
        if (this.cleanUpTimestampToCreationDate.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_CREATIONDATE);
        }
        if (this.cleanUpTimestampToModificationDate.isSelected()) {
            activeJobs.add(CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_MODIFICATIONDATE);
        }
        activeJobs.add(CleanupPreferences.CleanupStep.FIX_FILE_LINKS);
        return new CleanupPreferences(activeJobs, new FieldFormatterCleanups(this.formatterCleanupsPanel.cleanupsDisableProperty().getValue() == false, (List<FieldFormatterCleanup>)this.formatterCleanupsPanel.cleanupsProperty()));
    }
}

