/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.auximport;

import java.util.stream.Collectors;
import org.jabref.logic.auxparser.AuxParserResult;
import org.jabref.logic.l10n.Localization;

public class AuxParserResultViewModel {
    private AuxParserResult auxParserResult;

    public AuxParserResultViewModel(AuxParserResult auxParserResult) {
        this.auxParserResult = auxParserResult;
    }

    public String getInformation(boolean includeMissingEntries) {
        String missingEntries = "";
        if (includeMissingEntries && this.auxParserResult.getUnresolvedKeysCount() > 0) {
            missingEntries = this.auxParserResult.getUnresolvedKeys().stream().collect(Collectors.joining(", ", " (", ")"));
        }
        StringBuilder result = new StringBuilder();
        result.append(Localization.lang("keys in library", new Object[0])).append(' ').append(this.auxParserResult.getMasterDatabase().getEntryCount()).append('\n').append(Localization.lang("found in AUX file", new Object[0])).append(' ').append(this.auxParserResult.getFoundKeysInAux()).append('\n').append(Localization.lang("resolved", new Object[0])).append(' ').append(this.auxParserResult.getResolvedKeysCount()).append('\n').append(Localization.lang("not found", new Object[0])).append(' ').append(this.auxParserResult.getUnresolvedKeysCount()).append(missingEntries).append('\n').append(Localization.lang("crossreferenced entries included", new Object[0])).append(' ').append(this.auxParserResult.getCrossRefEntriesCount()).append('\n').append(Localization.lang("strings included", new Object[0])).append(' ').append(this.auxParserResult.getInsertedStrings()).append('\n');
        if (this.auxParserResult.getNestedAuxCount() > 0) {
            result.append(Localization.lang("nested AUX files", new Object[0])).append(' ').append(this.auxParserResult.getNestedAuxCount());
        }
        return result.toString();
    }
}

