/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.util.Pair;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.edit.automaticfiededitor.LastAutomaticFieldEditorEdit;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.DialogWindowState;
import org.jabref.gui.util.OptionalObjectProperty;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateManager.class);
    private final CustomLocalDragboard localDragboard;
    private final ObservableList<BibDatabaseContext> openDatabases;
    private final OptionalObjectProperty<BibDatabaseContext> activeDatabase;
    private final OptionalObjectProperty<LibraryTab> activeTab;
    private final ReadOnlyListWrapper<GroupTreeNode> activeGroups;
    private final ObservableList<BibEntry> selectedEntries;
    private final ObservableMap<String, ObservableList<GroupTreeNode>> selectedGroups;
    private final OptionalObjectProperty<SearchQuery> activeSearchQuery;
    private final OptionalObjectProperty<SearchQuery> activeGlobalSearchQuery;
    private final IntegerProperty globalSearchResultSize;
    private final ObservableMap<String, IntegerProperty> searchResultMap;
    private final OptionalObjectProperty<Node> focusOwner;
    private final ObservableList<Pair<BackgroundTask<?>, Task<?>>> backgroundTasks;
    private final EasyBinding<Boolean> anyTaskRunning;
    private final EasyBinding<Boolean> anyTasksThatWillNotBeRecoveredRunning;
    private final EasyBinding<Double> tasksProgress;
    private final ObservableMap<String, DialogWindowState> dialogWindowStates;
    private final ObservableList<SidePaneType> visibleSidePanes;
    private final ObjectProperty<LastAutomaticFieldEditorEdit> lastAutomaticFieldEditorEdit;
    private final ObservableList<String> searchHistory;

    /*
     * Exception decompiling
     */
    public StateManager() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ObservableList<SidePaneType> getVisibleSidePaneComponents() {
        return this.visibleSidePanes;
    }

    public CustomLocalDragboard getLocalDragboard() {
        return this.localDragboard;
    }

    public ObservableList<BibDatabaseContext> getOpenDatabases() {
        return this.openDatabases;
    }

    public OptionalObjectProperty<BibDatabaseContext> activeDatabaseProperty() {
        return this.activeDatabase;
    }

    public OptionalObjectProperty<LibraryTab> activeTabProperty() {
        return this.activeTab;
    }

    public OptionalObjectProperty<SearchQuery> activeSearchQueryProperty() {
        return this.activeSearchQuery;
    }

    public void setActiveSearchResultSize(BibDatabaseContext database, IntegerProperty resultSize) {
        this.searchResultMap.put((Object)database.getUid(), (Object)resultSize);
    }

    public IntegerProperty getSearchResultSize() {
        return (IntegerProperty)this.searchResultMap.getOrDefault((Object)((Optional)this.activeDatabase.getValue()).orElse(new BibDatabaseContext()).getUid(), (Object)new SimpleIntegerProperty(0));
    }

    public OptionalObjectProperty<SearchQuery> activeGlobalSearchQueryProperty() {
        return this.activeGlobalSearchQuery;
    }

    public IntegerProperty getGlobalSearchResultSize() {
        return this.globalSearchResultSize;
    }

    public IntegerProperty getSearchResultSize(OptionalObjectProperty<SearchQuery> searchQueryProperty) {
        if (((Object)searchQueryProperty).equals(this.activeSearchQuery)) {
            return this.getSearchResultSize();
        }
        return this.getGlobalSearchResultSize();
    }

    public ReadOnlyListProperty<GroupTreeNode> activeGroupProperty() {
        return this.activeGroups.getReadOnlyProperty();
    }

    public ObservableList<BibEntry> getSelectedEntries() {
        return this.selectedEntries;
    }

    public void setSelectedEntries(List<BibEntry> newSelectedEntries) {
        this.selectedEntries.setAll(newSelectedEntries);
    }

    public void setSelectedGroups(BibDatabaseContext database, List<GroupTreeNode> newSelectedGroups) {
        Objects.requireNonNull(newSelectedGroups);
        this.selectedGroups.put((Object)database.getUid(), (Object)FXCollections.observableArrayList(newSelectedGroups));
    }

    public ObservableList<GroupTreeNode> getSelectedGroups(BibDatabaseContext context) {
        ObservableList selectedGroupsForDatabase = (ObservableList)this.selectedGroups.get((Object)context.getUid());
        return selectedGroupsForDatabase != null ? selectedGroupsForDatabase : FXCollections.observableArrayList();
    }

    public void clearSelectedGroups(BibDatabaseContext database) {
        this.selectedGroups.remove((Object)database.getUid());
    }

    public Optional<BibDatabaseContext> getActiveDatabase() {
        return (Optional)this.activeDatabase.get();
    }

    public void setActiveDatabase(BibDatabaseContext database) {
        if (database == null) {
            LOGGER.info("No open database detected");
            this.activeDatabaseProperty().set(Optional.empty());
        } else {
            this.activeDatabaseProperty().set(Optional.of(database));
        }
    }

    public void clearSearchQuery() {
        this.activeSearchQuery.setValue(Optional.empty());
    }

    public void setSearchQuery(OptionalObjectProperty<SearchQuery> searchQueryProperty, SearchQuery query) {
        searchQueryProperty.setValue(Optional.of(query));
    }

    public void clearSearchQuery(OptionalObjectProperty<SearchQuery> searchQueryProperty) {
        searchQueryProperty.setValue(Optional.empty());
    }

    public OptionalObjectProperty<Node> focusOwnerProperty() {
        return this.focusOwner;
    }

    public Optional<Node> getFocusOwner() {
        return (Optional)this.focusOwner.get();
    }

    public ObservableList<Task<?>> getBackgroundTasks() {
        return EasyBind.map(this.backgroundTasks, Pair::getValue);
    }

    public void addBackgroundTask(BackgroundTask<?> backgroundTask, Task<?> task) {
        this.backgroundTasks.addFirst((Object)new Pair(backgroundTask, task));
    }

    public EasyBinding<Boolean> getAnyTaskRunning() {
        return this.anyTaskRunning;
    }

    public EasyBinding<Boolean> getAnyTasksThatWillNotBeRecoveredRunning() {
        return this.anyTasksThatWillNotBeRecoveredRunning;
    }

    public EasyBinding<Double> getTasksProgress() {
        return this.tasksProgress;
    }

    public DialogWindowState getDialogWindowState(String className) {
        return (DialogWindowState)this.dialogWindowStates.get((Object)className);
    }

    public void setDialogWindowState(String className, DialogWindowState state) {
        this.dialogWindowStates.put((Object)className, (Object)state);
    }

    public ObjectProperty<LastAutomaticFieldEditorEdit> lastAutomaticFieldEditorEditProperty() {
        return this.lastAutomaticFieldEditorEdit;
    }

    public LastAutomaticFieldEditorEdit getLastAutomaticFieldEditorEdit() {
        return (LastAutomaticFieldEditorEdit)this.lastAutomaticFieldEditorEditProperty().get();
    }

    public void setLastAutomaticFieldEditorEdit(LastAutomaticFieldEditorEdit automaticFieldEditorEdit) {
        this.lastAutomaticFieldEditorEditProperty().set((Object)automaticFieldEditorEdit);
    }

    public List<String> collectAllDatabasePaths() {
        ArrayList<String> list = new ArrayList<String>();
        this.getOpenDatabases().stream().map(BibDatabaseContext::getDatabasePath).forEachOrdered(pathOptional -> pathOptional.ifPresentOrElse(path -> list.add(path.toAbsolutePath().toString()), () -> list.add("")));
        return list;
    }

    public void addSearchHistory(String search) {
        this.searchHistory.remove((Object)search);
        this.searchHistory.add((Object)search);
    }

    public ObservableList<String> getWholeSearchHistory() {
        return this.searchHistory;
    }

    public List<String> getLastSearchHistory(int size) {
        int sizeSearches = this.searchHistory.size();
        if (size < sizeSearches) {
            return this.searchHistory.subList(sizeSearches - size, sizeSearches);
        }
        return this.searchHistory;
    }

    public void clearSearchHistory() {
        this.searchHistory.clear();
    }

    private static /* synthetic */ Double lambda$new$4(Stream tasks) {
        return tasks.map(Pair::getValue).filter(Task::isRunning).mapToDouble(Task::getProgress).average().orElse(1.0);
    }

    private static /* synthetic */ Boolean lambda$new$3(Stream tasks) {
        return tasks.anyMatch(task -> !((BackgroundTask)task.getKey()).willBeRecoveredAutomatically() && ((Task)task.getValue()).isRunning());
    }

    private static /* synthetic */ Boolean lambda$new$1(Stream tasks) {
        return tasks.map(Pair::getValue).anyMatch(Task::isRunning);
    }
}

