/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import com.google.common.eventbus.Subscribe;
import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.UpdateTimestampListener;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.autocompleter.PersonNameSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.autosaveandbackup.AutosaveManager;
import org.jabref.gui.autosaveandbackup.BackupManager;
import org.jabref.gui.collab.DatabaseChangeMonitor;
import org.jabref.gui.dialogs.AutosaveUiManager;
import org.jabref.gui.entryeditor.EntryEditor;
import org.jabref.gui.exporter.SaveDatabaseAction;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.linkedfile.DeleteFileAction;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTable;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.undo.UndoableInsertEntries;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.citationstyle.CitationStyleCache;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.logic.pdf.search.PdfIndexerManager;
import org.jabref.logic.search.SearchQuery;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.util.UpdateField;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.jabref.model.database.event.EntriesAddedEvent;
import org.jabref.model.database.event.EntriesRemovedEvent;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.event.FieldChangedEvent;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.util.DirectoryMonitor;
import org.jabref.model.util.DirectoryMonitorManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryTab
extends Tab {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryTab.class);
    private final LibraryTabContainer tabContainer;
    private final CountingUndoManager undoManager;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final StateManager stateManager;
    private final BibEntryTypesManager entryTypesManager;
    private final BooleanProperty changedProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty nonUndoableChangeProperty = new SimpleBooleanProperty(false);
    private BibDatabaseContext bibDatabaseContext;
    private MainTableDataModel tableModel;
    private CitationStyleCache citationStyleCache;
    private FileAnnotationCache annotationCache;
    private EntryEditor entryEditor;
    private MainTable mainTable;
    private PanelMode mode = PanelMode.MAIN_TABLE;
    private SplitPane splitPane;
    private DatabaseNotification databaseNotificationPane;
    private final SimpleBooleanProperty loading = new SimpleBooleanProperty(false);
    private boolean saving = false;
    private PersonNameSuggestionProvider searchAutoCompleter;
    private BibEntry showing;
    private SuggestionProviders suggestionProviders;
    private Subscription dividerPositionSubscription;
    private Optional<SearchQuery> currentSearchQuery = Optional.empty();
    private Optional<DatabaseChangeMonitor> changeMonitor = Optional.empty();
    private BackgroundTask<ParserResult> dataLoadingTask;
    private final ClipBoardManager clipBoardManager;
    private final IndexingTaskManager indexingTaskManager;
    private final TaskExecutor taskExecutor;
    private final DirectoryMonitorManager directoryMonitorManager;

    private LibraryTab(BibDatabaseContext bibDatabaseContext, LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, CountingUndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        this.tabContainer = Objects.requireNonNull(tabContainer);
        this.bibDatabaseContext = Objects.requireNonNull(bibDatabaseContext);
        this.undoManager = undoManager;
        this.dialogService = dialogService;
        this.preferencesService = Objects.requireNonNull(preferencesService);
        this.stateManager = Objects.requireNonNull(stateManager);
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.entryTypesManager = entryTypesManager;
        this.clipBoardManager = clipBoardManager;
        this.indexingTaskManager = new IndexingTaskManager(taskExecutor);
        this.taskExecutor = taskExecutor;
        this.directoryMonitorManager = new DirectoryMonitorManager((DirectoryMonitor)Injector.instantiateModelOrService(DirectoryMonitor.class));
        bibDatabaseContext.getDatabase().registerListener((Object)this);
        bibDatabaseContext.getMetaData().registerListener((Object)this);
        this.tableModel = new MainTableDataModel(this.getBibDatabaseContext(), preferencesService, stateManager);
        this.citationStyleCache = new CitationStyleCache(bibDatabaseContext);
        this.annotationCache = new FileAnnotationCache(bibDatabaseContext, preferencesService.getFilePreferences());
        this.setupMainPanel();
        this.setupAutoCompletion();
        this.getDatabase().registerListener(new IndexUpdateListener());
        this.getDatabase().registerListener(new EntriesRemovedListener());
        this.bibDatabaseContext.getDatabase().registerListener(new GroupTreeListener());
        this.bibDatabaseContext.getDatabase().registerListener((Object)this);
        this.getDatabase().registerListener(new UpdateTimestampListener(preferencesService));
        this.entryEditor = this.createEntryEditor();
        this.setId(Long.valueOf(new Random().nextLong()).toString());
        Platform.runLater(() -> {
            EasyBind.subscribe((ObservableValue)this.changedProperty, this::updateTabTitle);
            stateManager.getOpenDatabases().addListener(c -> this.updateTabTitle(this.changedProperty.getValue()));
        });
        this.setOnCloseRequest(this::onCloseRequest);
        this.setOnClosed(this::onClosed);
    }

    private EntryEditor createEntryEditor() {
        Supplier<LibraryTab> tabSupplier = () -> this;
        return new EntryEditor(this, new UndoAction(tabSupplier, this.dialogService, this.stateManager), new RedoAction(tabSupplier, this.dialogService, this.stateManager));
    }

    private static void addChangedInformation(StringBuilder text, String fileName) {
        text.append("\n");
        text.append(Localization.lang("Library '%0' has changed.", fileName));
    }

    private static void addModeInfo(StringBuilder text, BibDatabaseContext bibDatabaseContext) {
        String mode = bibDatabaseContext.getMode().getFormattedName();
        String modeInfo = "\n%s".formatted(Localization.lang("%0 mode", mode));
        text.append(modeInfo);
    }

    private static void addSharedDbInformation(StringBuilder text, BibDatabaseContext bibDatabaseContext) {
        text.append(bibDatabaseContext.getDBMSSynchronizer().getDBName());
        text.append(" [");
        text.append(Localization.lang("shared", new Object[0]));
        text.append("]");
    }

    private void setDataLoadingTask(BackgroundTask<ParserResult> dataLoadingTask) {
        this.loading.set(true);
        this.dataLoadingTask = dataLoadingTask;
    }

    private Node createLoadingAnimationLayout() {
        ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)progressIndicator);
        return pane;
    }

    private void onDatabaseLoadingStarted() {
        Node loadingLayout = this.createLoadingAnimationLayout();
        this.getMainTable().placeholderProperty().setValue((Object)loadingLayout);
    }

    private void onDatabaseLoadingSucceed(ParserResult result) {
        BibDatabaseContext context = result.getDatabaseContext();
        OpenDatabaseAction.performPostOpenActions(result, this.dialogService, this.preferencesService);
        this.setDatabaseContext(context);
        if (this.preferencesService.getFilePreferences().shouldFulltextIndexLinkedFiles()) {
            try {
                this.indexingTaskManager.updateIndex(PdfIndexerManager.getIndexer(this.bibDatabaseContext, this.preferencesService.getFilePreferences()), this.bibDatabaseContext);
            }
            catch (IOException e) {
                LOGGER.error("Cannot access lucene index", (Throwable)e);
            }
        }
        LOGGER.trace("loading.set(false);");
        this.loading.set(false);
        this.dataLoadingTask = null;
    }

    private void onDatabaseLoadingFailed(Exception ex) {
        this.loading.set(false);
        String title = Localization.lang("Connection error", new Object[0]);
        String content = "%s\n\n%s".formatted(ex.getMessage(), Localization.lang("A local copy will be opened.", new Object[0]));
        this.dialogService.showErrorDialogAndWait(title, content, ex);
    }

    private void setDatabaseContext(BibDatabaseContext bibDatabaseContext) {
        TabPane tabPane = this.getTabPane();
        if (tabPane == null) {
            LOGGER.debug("User interrupted loading. Not showing any library.");
            return;
        }
        if (((Tab)tabPane.getSelectionModel().selectedItemProperty().get()).equals((Object)this)) {
            LOGGER.debug("This case should not happen.");
            this.stateManager.setActiveDatabase(bibDatabaseContext);
            this.stateManager.activeTabProperty().set(Optional.of(this));
        }
        Optional<BibDatabaseContext> foundExistingBibDatabase = this.stateManager.getOpenDatabases().stream().filter(databaseContext -> databaseContext.equals(this.bibDatabaseContext)).findFirst();
        foundExistingBibDatabase.ifPresent(databaseContext -> this.stateManager.getOpenDatabases().remove(databaseContext));
        this.bibDatabaseContext = Objects.requireNonNull(bibDatabaseContext);
        this.stateManager.getOpenDatabases().add((Object)bibDatabaseContext);
        bibDatabaseContext.getDatabase().registerListener((Object)this);
        bibDatabaseContext.getMetaData().registerListener((Object)this);
        this.tableModel = new MainTableDataModel(this.getBibDatabaseContext(), this.preferencesService, this.stateManager);
        this.citationStyleCache = new CitationStyleCache(bibDatabaseContext);
        this.annotationCache = new FileAnnotationCache(bibDatabaseContext, this.preferencesService.getFilePreferences());
        this.setupMainPanel();
        this.setupAutoCompletion();
        this.getDatabase().registerListener(new IndexUpdateListener());
        this.getDatabase().registerListener(new EntriesRemovedListener());
        this.bibDatabaseContext.getDatabase().registerListener(new GroupTreeListener());
        this.bibDatabaseContext.getDatabase().registerListener((Object)this);
        this.getDatabase().registerListener(new UpdateTimestampListener(this.preferencesService));
        this.entryEditor = this.createEntryEditor();
        Platform.runLater(() -> {
            EasyBind.subscribe((ObservableValue)this.changedProperty, this::updateTabTitle);
            this.stateManager.getOpenDatabases().addListener(c -> this.updateTabTitle(this.changedProperty.getValue()));
        });
        this.installAutosaveManagerAndBackupManager();
    }

    public void installAutosaveManagerAndBackupManager() {
        if (this.isDatabaseReadyForAutoSave(this.bibDatabaseContext)) {
            AutosaveManager autosaveManager = AutosaveManager.start(this.bibDatabaseContext);
            autosaveManager.registerListener(new AutosaveUiManager(this, this.dialogService, this.preferencesService, this.entryTypesManager));
        }
        if (this.isDatabaseReadyForBackup(this.bibDatabaseContext) && this.preferencesService.getFilePreferences().shouldCreateBackup()) {
            BackupManager.start(this, this.bibDatabaseContext, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class), this.preferencesService);
        }
    }

    private boolean isDatabaseReadyForAutoSave(BibDatabaseContext context) {
        return (context.getLocation() == DatabaseLocation.SHARED || context.getLocation() == DatabaseLocation.LOCAL && this.preferencesService.getLibraryPreferences().shouldAutoSave()) && context.getDatabasePath().isPresent();
    }

    private boolean isDatabaseReadyForBackup(BibDatabaseContext context) {
        return context.getLocation() == DatabaseLocation.LOCAL && context.getDatabasePath().isPresent();
    }

    public void updateTabTitle(boolean isChanged) {
        boolean isAutosaveEnabled = this.preferencesService.getLibraryPreferences().shouldAutoSave();
        DatabaseLocation databaseLocation = this.bibDatabaseContext.getLocation();
        Optional<Path> file = this.bibDatabaseContext.getDatabasePath();
        StringBuilder tabTitle = new StringBuilder();
        StringBuilder toolTipText = new StringBuilder();
        if (file.isPresent()) {
            if (isChanged && !isAutosaveEnabled) {
                tabTitle.append('*');
            }
            Path databasePath = file.get();
            String fileName = databasePath.getFileName().toString();
            tabTitle.append(fileName);
            toolTipText.append(databasePath.toAbsolutePath());
            if (databaseLocation == DatabaseLocation.SHARED) {
                tabTitle.append(" \u2013 ");
                LibraryTab.addSharedDbInformation(tabTitle, this.bibDatabaseContext);
                toolTipText.append(' ');
                LibraryTab.addSharedDbInformation(toolTipText, this.bibDatabaseContext);
            }
            LibraryTab.addModeInfo(toolTipText, this.bibDatabaseContext);
            if (isChanged && !isAutosaveEnabled) {
                LibraryTab.addChangedInformation(toolTipText, fileName);
            }
            Optional<String> uniquePathPart = FileUtil.getUniquePathDirectory(this.stateManager.collectAllDatabasePaths(), databasePath);
            uniquePathPart.ifPresent(part -> tabTitle.append(" \u2013 ").append((String)part));
        } else {
            if (databaseLocation == DatabaseLocation.LOCAL) {
                tabTitle.append(Localization.lang("untitled", new Object[0]));
                if (this.bibDatabaseContext.getDatabase().hasEntries()) {
                    tabTitle.append('*');
                }
            } else {
                LibraryTab.addSharedDbInformation(tabTitle, this.bibDatabaseContext);
                LibraryTab.addSharedDbInformation(toolTipText, this.bibDatabaseContext);
            }
            LibraryTab.addModeInfo(toolTipText, this.bibDatabaseContext);
            if (databaseLocation == DatabaseLocation.LOCAL && this.bibDatabaseContext.getDatabase().hasEntries()) {
                LibraryTab.addChangedInformation(toolTipText, Localization.lang("untitled", new Object[0]));
            }
        }
        UiTaskExecutor.runInJavaFXThread(() -> {
            this.textProperty().setValue(tabTitle.toString());
            this.setTooltip(new Tooltip(toolTipText.toString()));
        });
        if (this.preferencesService.getFilePreferences().shouldFulltextIndexLinkedFiles()) {
            this.indexingTaskManager.updateDatabaseName(tabTitle.toString());
        }
    }

    @Subscribe
    public void listen(BibDatabaseContextChangedEvent event) {
        this.changedProperty.setValue(Boolean.valueOf(true));
    }

    public SuggestionProviders getSuggestionProviders() {
        return this.suggestionProviders;
    }

    public void delete(StandardActions mode) {
        this.delete(mode, this.mainTable.getSelectedEntries());
    }

    private void delete(StandardActions mode, List<BibEntry> entries) {
        List linkedFileList;
        if (entries.isEmpty()) {
            return;
        }
        if (mode == StandardActions.DELETE_ENTRY && !this.showDeleteConfirmationDialog(entries.size())) {
            return;
        }
        this.getUndoManager().addEdit(new UndoableRemoveEntries(this.bibDatabaseContext.getDatabase(), entries, mode == StandardActions.CUT));
        this.bibDatabaseContext.getDatabase().removeEntries(entries);
        if (mode != StandardActions.CUT && !(linkedFileList = entries.stream().flatMap(entry -> entry.getFiles().stream()).distinct().toList()).isEmpty()) {
            List<LinkedFileViewModel> viewModels = linkedFileList.stream().map(linkedFile -> linkedFile.toModel(null, this.bibDatabaseContext, null, null, this.preferencesService)).collect(Collectors.toList());
            new DeleteFileAction(this.dialogService, this.preferencesService.getFilePreferences(), this.bibDatabaseContext, viewModels).execute();
        }
        this.ensureNotShowingBottomPanel(entries);
        this.changedProperty.setValue(Boolean.valueOf(true));
        switch (mode) {
            case CUT: {
                this.dialogService.notify(Localization.lang("Cut %0 entry(ies)", entries.size()));
                break;
            }
            case DELETE_ENTRY: {
                this.dialogService.notify(Localization.lang("Deleted %0 entry(ies)", entries.size()));
            }
        }
        this.mainTable.requestFocus();
    }

    public void delete(BibEntry entry) {
        this.delete(StandardActions.DELETE_ENTRY, Collections.singletonList(entry));
    }

    public void registerUndoableChanges(List<FieldChange> changes) {
        NamedCompound ce = new NamedCompound(Localization.lang("Save actions", new Object[0]));
        for (FieldChange change : changes) {
            ce.addEdit(new UndoableFieldChange(change));
        }
        ce.end();
        if (ce.hasEdits()) {
            this.getUndoManager().addEdit(ce);
        }
    }

    public void insertEntry(BibEntry bibEntry) {
        if (bibEntry != null) {
            this.insertEntries(Collections.singletonList(bibEntry));
        }
    }

    public void insertEntries(List<BibEntry> entries) {
        if (!entries.isEmpty()) {
            this.bibDatabaseContext.getDatabase().insertEntries(entries);
            UpdateField.setAutomaticFields(entries, this.preferencesService.getOwnerPreferences(), this.preferencesService.getTimestampPreferences());
            this.getUndoManager().addEdit(new UndoableInsertEntries(this.bibDatabaseContext.getDatabase(), entries));
            this.changedProperty.setValue(Boolean.valueOf(true));
            if (this.preferencesService.getEntryEditorPreferences().shouldOpenOnNewEntry()) {
                this.showAndEdit(entries.getFirst());
            }
            this.clearAndSelect(entries.getFirst());
        }
    }

    public void editEntryAndFocusField(BibEntry entry, Field field) {
        this.showAndEdit(entry);
        Platform.runLater(() -> {
            this.entryEditor.setFocusToField(field);
            this.clearAndSelect(entry);
        });
    }

    private void createMainTable() {
        this.mainTable = new MainTable(this.tableModel, this, this.tabContainer, this.bibDatabaseContext, this.preferencesService, this.dialogService, this.stateManager, this.preferencesService.getKeyBindingRepository(), this.clipBoardManager, this.entryTypesManager, this.taskExecutor, this.fileUpdateMonitor);
        this.mainTable.addSelectionListener((ListChangeListener<? super BibEntryTableViewModel>)((ListChangeListener)event -> {
            List<BibEntry> entries = event.getList().stream().map(BibEntryTableViewModel::getEntry).toList();
            this.stateManager.setSelectedEntries(entries);
            if (!entries.isEmpty()) {
                this.entryEditor.setCurrentlyEditedEntry(entries.getFirst());
            }
        }));
    }

    public void setupMainPanel() {
        this.splitPane = new SplitPane();
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.createMainTable();
        this.splitPane.getItems().add((Object)this.mainTable);
        this.databaseNotificationPane = new DatabaseNotification((Node)this.splitPane);
        this.setContent((Node)this.databaseNotificationPane);
        this.dividerPositionSubscription = EasyBind.valueAt((ObservableList)this.splitPane.getDividers(), (int)0).mapObservable(SplitPane.Divider::positionProperty).subscribeToValues(this::saveDividerLocation);
        Optional<Path> file = this.bibDatabaseContext.getDatabasePath();
        if (file.isPresent()) {
            this.resetChangeMonitor();
        } else if (this.bibDatabaseContext.getDatabase().hasEntries()) {
            this.changedProperty.setValue(Boolean.valueOf(true));
        }
    }

    private void setupAutoCompletion() {
        AutoCompletePreferences autoCompletePreferences = this.preferencesService.getAutoCompletePreferences();
        this.suggestionProviders = autoCompletePreferences.shouldAutoComplete() ? new SuggestionProviders(this.getDatabase(), (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class), autoCompletePreferences) : new SuggestionProviders();
        this.searchAutoCompleter = new PersonNameSuggestionProvider(FieldFactory.getPersonNameFields(), this.getDatabase());
    }

    public SuggestionProvider<Author> getAutoCompleter() {
        return this.searchAutoCompleter;
    }

    public EntryEditor getEntryEditor() {
        return this.entryEditor;
    }

    public void showAndEdit(BibEntry entry) {
        if (!this.splitPane.getItems().contains((Object)this.entryEditor)) {
            this.splitPane.getItems().addLast((Object)this.entryEditor);
            this.mode = PanelMode.MAIN_TABLE_AND_ENTRY_EDITOR;
            this.splitPane.setDividerPositions(new double[]{this.preferencesService.getEntryEditorPreferences().getDividerPosition()});
        }
        if (entry != this.showing) {
            this.entryEditor.setCurrentlyEditedEntry(entry);
            this.showing = entry;
        }
        this.entryEditor.requestFocus();
    }

    public void closeBottomPane() {
        this.mode = PanelMode.MAIN_TABLE;
        this.splitPane.getItems().remove((Object)this.entryEditor);
    }

    public void clearAndSelect(BibEntry bibEntry) {
        this.mainTable.clearAndSelect(bibEntry);
    }

    public void selectPreviousEntry() {
        this.mainTable.getSelectionModel().clearAndSelect(this.mainTable.getSelectionModel().getSelectedIndex() - 1);
    }

    public void selectNextEntry() {
        this.mainTable.getSelectionModel().clearAndSelect(this.mainTable.getSelectionModel().getSelectedIndex() + 1);
    }

    public void entryEditorClosing() {
        this.closeBottomPane();
        this.mainTable.requestFocus();
    }

    private void ensureNotShowingBottomPanel(List<BibEntry> entriesToCheck) {
        if (this.mode == PanelMode.MAIN_TABLE_AND_ENTRY_EDITOR && entriesToCheck.contains(this.entryEditor.getCurrentlyEditedEntry())) {
            this.closeBottomPane();
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == PanelMode.MAIN_TABLE_AND_ENTRY_EDITOR) {
            BibEntry currentEntry = this.entryEditor.getCurrentlyEditedEntry();
            this.showAndEdit(currentEntry);
        }
    }

    public synchronized void markChangedOrUnChanged() {
        if (this.undoManager.hasChanged()) {
            this.changedProperty.setValue(Boolean.valueOf(true));
        } else if (this.changedProperty.getValue().booleanValue() && !this.nonUndoableChangeProperty.getValue().booleanValue()) {
            this.changedProperty.setValue(Boolean.valueOf(false));
        }
    }

    public BibDatabase getDatabase() {
        return this.bibDatabaseContext.getDatabase();
    }

    private boolean showDeleteConfirmationDialog(int numberOfEntries) {
        if (this.preferencesService.getWorkspacePreferences().shouldConfirmDelete()) {
            String title = Localization.lang("Delete entry", new Object[0]);
            String message = Localization.lang("Really delete the selected entry?", new Object[0]);
            String okButton = Localization.lang("Delete entry", new Object[0]);
            String cancelButton = Localization.lang("Keep entry", new Object[0]);
            if (numberOfEntries > 1) {
                title = Localization.lang("Delete multiple entries", new Object[0]);
                message = Localization.lang("Really delete the %0 selected entries?", Integer.toString(numberOfEntries));
                okButton = Localization.lang("Delete entries", new Object[0]);
                cancelButton = Localization.lang("Keep entries", new Object[0]);
            }
            return this.dialogService.showConfirmationDialogWithOptOutAndWait(title, message, okButton, cancelButton, Localization.lang("Do not ask again", new Object[0]), optOut -> this.preferencesService.getWorkspacePreferences().setConfirmDelete(optOut == false));
        }
        return true;
    }

    private void saveDividerLocation(Number position) {
        if (this.mode == PanelMode.MAIN_TABLE_AND_ENTRY_EDITOR) {
            this.preferencesService.getEntryEditorPreferences().setDividerPosition(position.doubleValue());
        }
    }

    public boolean requestClose() {
        if (this.bibDatabaseContext.getLocation() == DatabaseLocation.LOCAL && this.isModified()) {
            return this.confirmClose();
        }
        return true;
    }

    private boolean confirmClose() {
        if (this.dataLoadingTask != null) {
            this.dataLoadingTask.cancel();
            this.loading.setValue(Boolean.valueOf(false));
            return true;
        }
        String filename = this.getBibDatabaseContext().getDatabasePath().map(Path::toAbsolutePath).map(Path::toString).orElse(Localization.lang("untitled", new Object[0]));
        ButtonType saveChanges = new ButtonType(Localization.lang("Save changes", new Object[0]), ButtonBar.ButtonData.YES);
        ButtonType discardChanges = new ButtonType(Localization.lang("Discard changes", new Object[0]), ButtonBar.ButtonData.NO);
        ButtonType returnToLibrary = new ButtonType(Localization.lang("Return to library", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
        Optional<ButtonType> response = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.CONFIRMATION, Localization.lang("Save before closing", new Object[0]), Localization.lang("Library '%0' has changed.", filename), saveChanges, discardChanges, returnToLibrary);
        if (response.isEmpty()) {
            return true;
        }
        ButtonType buttonType = response.get();
        if (buttonType.equals(returnToLibrary)) {
            return false;
        }
        if (buttonType.equals(saveChanges)) {
            try {
                SaveDatabaseAction saveAction = new SaveDatabaseAction(this, this.dialogService, this.preferencesService, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
                if (saveAction.save()) {
                    return true;
                }
                this.dialogService.notify(Localization.lang("Unable to save library", new Object[0]));
            }
            catch (Throwable ex) {
                LOGGER.error("A problem occurred when trying to save the file", ex);
                this.dialogService.showErrorDialogAndWait(Localization.lang("Save library", new Object[0]), Localization.lang("Could not save file.", new Object[0]), ex);
            }
            return false;
        }
        if (buttonType.equals(discardChanges)) {
            BackupManager.discardBackup(this.bibDatabaseContext, this.preferencesService.getFilePreferences().getBackupDirectory());
            return true;
        }
        return false;
    }

    private void onCloseRequest(Event event) {
        if (!this.requestClose()) {
            event.consume();
        }
    }

    private void onClosed(Event event) {
        if (this.dataLoadingTask != null) {
            this.dataLoadingTask.cancel();
        }
        if (this.bibDatabaseContext.getLocation() == DatabaseLocation.SHARED) {
            this.bibDatabaseContext.convertToLocalDatabase();
            this.bibDatabaseContext.getDBMSSynchronizer().closeSharedDatabase();
            this.bibDatabaseContext.clearDBMSSynchronizer();
        }
        try {
            this.changeMonitor.ifPresent(DatabaseChangeMonitor::unregister);
        }
        catch (RuntimeException e) {
            LOGGER.error("Problem when closing change monitor", (Throwable)e);
        }
        try {
            this.directoryMonitorManager.unregister();
        }
        catch (RuntimeException e) {
            LOGGER.error("Problem when closing directory monitor", (Throwable)e);
        }
        try {
            PdfIndexerManager.shutdownIndexer(this.bibDatabaseContext);
        }
        catch (RuntimeException e) {
            LOGGER.error("Problem when shutting down PDF indexer", (Throwable)e);
        }
        try {
            AutosaveManager.shutdown(this.bibDatabaseContext);
        }
        catch (RuntimeException e) {
            LOGGER.error("Problem when shutting down autosave manager", (Throwable)e);
        }
        try {
            BackupManager.shutdown(this.bibDatabaseContext, this.preferencesService.getFilePreferences().getBackupDirectory(), this.preferencesService.getFilePreferences().shouldCreateBackup());
        }
        catch (RuntimeException e) {
            LOGGER.error("Problem when shutting down backup manager", (Throwable)e);
        }
        this.stateManager.clearSelectedGroups(this.bibDatabaseContext);
    }

    public List<BibEntry> getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public BibDatabaseContext getBibDatabaseContext() {
        return this.bibDatabaseContext;
    }

    public DirectoryMonitorManager getDirectoryMonitorManager() {
        return this.directoryMonitorManager;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public ObservableBooleanValue getLoading() {
        return this.loading;
    }

    public CountingUndoManager getUndoManager() {
        return this.undoManager;
    }

    public MainTable getMainTable() {
        return this.mainTable;
    }

    public Optional<SearchQuery> getCurrentSearchQuery() {
        return this.currentSearchQuery;
    }

    public void setCurrentSearchQuery(Optional<SearchQuery> currentSearchQuery) {
        this.currentSearchQuery = currentSearchQuery;
    }

    public CitationStyleCache getCitationStyleCache() {
        return this.citationStyleCache;
    }

    public FileAnnotationCache getAnnotationCache() {
        return this.annotationCache;
    }

    public void resetChangeMonitor() {
        this.changeMonitor.ifPresent(DatabaseChangeMonitor::unregister);
        this.changeMonitor = Optional.of(new DatabaseChangeMonitor(this.bibDatabaseContext, this.fileUpdateMonitor, this.taskExecutor, this.dialogService, this.preferencesService, this.databaseNotificationPane, this.undoManager, this.stateManager));
    }

    public void copy() {
        this.mainTable.copy();
    }

    public void paste() {
        this.mainTable.paste();
    }

    public void dropEntry(List<BibEntry> entriesToAdd) {
        this.mainTable.dropEntry(entriesToAdd);
    }

    public void cut() {
        this.mainTable.cut();
    }

    public boolean isModified() {
        return this.changedProperty.getValue();
    }

    public void markBaseChanged() {
        this.changedProperty.setValue(Boolean.valueOf(true));
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChangeProperty.setValue(Boolean.valueOf(true));
        this.changedProperty.setValue(Boolean.valueOf(true));
    }

    public void resetChangedProperties() {
        this.nonUndoableChangeProperty.setValue(Boolean.valueOf(false));
        this.changedProperty.setValue(Boolean.valueOf(false));
    }

    public static LibraryTab createLibraryTab(BackgroundTask<ParserResult> dataLoadingTask, Path file, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, LibraryTabContainer tabContainer, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, CountingUndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        BibDatabaseContext context = new BibDatabaseContext();
        context.setDatabasePath(file);
        LibraryTab newTab = new LibraryTab(context, tabContainer, dialogService, preferencesService, stateManager, fileUpdateMonitor, entryTypesManager, undoManager, clipBoardManager, taskExecutor);
        newTab.setDataLoadingTask(dataLoadingTask);
        dataLoadingTask.onRunning(newTab::onDatabaseLoadingStarted).onSuccess(newTab::onDatabaseLoadingSucceed).onFailure(newTab::onDatabaseLoadingFailed).executeWith(taskExecutor);
        return newTab;
    }

    public static LibraryTab createLibraryTab(BibDatabaseContext databaseContext, LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, UndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        Objects.requireNonNull(databaseContext);
        return new LibraryTab(databaseContext, tabContainer, dialogService, preferencesService, stateManager, fileUpdateMonitor, entryTypesManager, (CountingUndoManager)undoManager, clipBoardManager, taskExecutor);
    }

    public IndexingTaskManager getIndexingTaskManager() {
        return this.indexingTaskManager;
    }

    public DatabaseNotification getNotificationPane() {
        return this.databaseNotificationPane;
    }

    public String toString() {
        return "LibraryTab{bibDatabaseContext=" + String.valueOf(this.bibDatabaseContext) + ", showing=" + String.valueOf(this.showing) + "}";
    }

    private static enum PanelMode {
        MAIN_TABLE,
        MAIN_TABLE_AND_ENTRY_EDITOR;

    }

    private class IndexUpdateListener {
        private IndexUpdateListener() {
        }

        @Subscribe
        public void listen(EntriesAddedEvent addedEntryEvent) {
            if (LibraryTab.this.preferencesService.getFilePreferences().shouldFulltextIndexLinkedFiles()) {
                try {
                    PdfIndexer pdfIndexer = PdfIndexerManager.getIndexer(LibraryTab.this.bibDatabaseContext, LibraryTab.this.preferencesService.getFilePreferences());
                    LibraryTab.this.indexingTaskManager.addToIndex(pdfIndexer, addedEntryEvent.getBibEntries());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot access lucene index", (Throwable)e);
                }
            }
        }

        @Subscribe
        public void listen(EntriesRemovedEvent removedEntriesEvent) {
            if (LibraryTab.this.preferencesService.getFilePreferences().shouldFulltextIndexLinkedFiles()) {
                try {
                    PdfIndexer pdfIndexer = PdfIndexerManager.getIndexer(LibraryTab.this.bibDatabaseContext, LibraryTab.this.preferencesService.getFilePreferences());
                    for (BibEntry removedEntry : removedEntriesEvent.getBibEntries()) {
                        LibraryTab.this.indexingTaskManager.removeFromIndex(pdfIndexer, removedEntry);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Cannot access lucene index", (Throwable)e);
                }
            }
        }

        @Subscribe
        public void listen(FieldChangedEvent fieldChangedEvent) {
            if (LibraryTab.this.preferencesService.getFilePreferences().shouldFulltextIndexLinkedFiles() && fieldChangedEvent.getField().equals(StandardField.FILE)) {
                List<LinkedFile> oldFileList = FileFieldParser.parse(fieldChangedEvent.getOldValue());
                List<LinkedFile> newFileList = FileFieldParser.parse(fieldChangedEvent.getNewValue());
                ArrayList<LinkedFile> addedFiles = new ArrayList<LinkedFile>(newFileList);
                addedFiles.removeAll(oldFileList);
                ArrayList<LinkedFile> removedFiles = new ArrayList<LinkedFile>(oldFileList);
                removedFiles.removeAll(newFileList);
                try {
                    PdfIndexer indexer = PdfIndexerManager.getIndexer(LibraryTab.this.bibDatabaseContext, LibraryTab.this.preferencesService.getFilePreferences());
                    LibraryTab.this.indexingTaskManager.addToIndex(indexer, fieldChangedEvent.getBibEntry(), addedFiles);
                    LibraryTab.this.indexingTaskManager.removeFromIndex(indexer, removedFiles);
                }
                catch (IOException e) {
                    LOGGER.warn("I/O error when writing lucene index", (Throwable)e);
                }
            }
        }
    }

    private class EntriesRemovedListener {
        private EntriesRemovedListener() {
        }

        @Subscribe
        public void listen(EntriesRemovedEvent entriesRemovedEvent) {
            LibraryTab.this.ensureNotShowingBottomPanel(entriesRemovedEvent.getBibEntries());
        }
    }

    private class GroupTreeListener {
        private GroupTreeListener() {
        }

        @Subscribe
        public void listen(EntriesAddedEvent addedEntriesEvent) {
            if (addedEntriesEvent.getEntriesEventSource() == EntriesEventSource.UNDO) {
                return;
            }
            if (LibraryTab.this.preferencesService.getGroupsPreferences().shouldAutoAssignGroup()) {
                LibraryTab.this.stateManager.getSelectedGroups(LibraryTab.this.bibDatabaseContext).forEach(selectedGroup -> selectedGroup.addEntriesToGroup(addedEntriesEvent.getBibEntries()));
            }
        }
    }

    public static class DatabaseNotification
    extends NotificationPane {
        public DatabaseNotification(Node content) {
            super(content);
        }

        public void notify(Node graphic, String text, List<Action> actions, Duration duration) {
            this.setGraphic(graphic);
            this.setText(text);
            this.getActions().setAll(actions);
            this.show();
            if (duration != null && !duration.equals((Object)Duration.ZERO)) {
                PauseTransition delay = new PauseTransition(duration);
                delay.setOnFinished(e -> this.hide());
                delay.play();
            }
        }
    }
}

