/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.EnumSet;
import java.util.Objects;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public class UserSpecificCommentField
implements Field {
    private static final EnumSet<FieldProperty> PROPERTIES = EnumSet.of(FieldProperty.MULTILINE_TEXT, FieldProperty.MARKDOWN);
    private final String name;

    public UserSpecificCommentField(String username) {
        this.name = "comment-" + username;
    }

    @Override
    public EnumSet<FieldProperty> getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStandardField() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "UnknownCommentField{name='" + this.name + "'}";
    }
}

