/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.StringJoiner;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class OrFields
implements Comparable<OrFields> {
    private SequencedSet<Field> fields = new LinkedHashSet<Field>();

    public OrFields(Field field) {
        this.fields.add(field);
    }

    public OrFields(Field ... fieldsToAdd) {
        Arrays.stream(fieldsToAdd).forEach(this.fields::add);
    }

    public OrFields(Collection<Field> fieldsToAdd) {
        this.fields.addAll(fieldsToAdd);
    }

    public String getDisplayName() {
        StringJoiner joiner = new StringJoiner("/");
        for (Field field : this.fields) {
            joiner.add(field.getDisplayName());
        }
        return joiner.toString();
    }

    public Field getPrimary() {
        return (Field)this.fields.getFirst();
    }

    public SequencedSet<Field> getFields() {
        return this.fields;
    }

    public boolean contains(Field field) {
        return this.fields.contains(field);
    }

    @Override
    public int compareTo(OrFields o) {
        return FieldFactory.serializeOrFields(this).compareTo(FieldFactory.serializeOrFields(o));
    }

    public boolean hasExactlyOne() {
        return this.fields.size() == 1;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrFields orFields = (OrFields)o;
        return Objects.equals(this.fields, orFields.fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }

    public String toString() {
        return "OrFields{fields=" + String.valueOf(this.fields) + "}";
    }
}

