/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.formatter.bibtexfields.RemoveEnclosingBracesFormatter;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationLookupResult;
import org.jabref.model.openoffice.style.CitationMarkerEntry;
import org.jabref.model.openoffice.style.CitationMarkerNormEntry;
import org.jabref.model.openoffice.style.NonUniqueCitationMarker;
import org.jabref.model.openoffice.style.PageInfo;
import org.jabref.model.strings.StringUtil;
import org.jspecify.annotations.NonNull;

class OOBibStyleGetCitationMarker {
    private static final RemoveEnclosingBracesFormatter REMOVE_BRACES_FORMATTER = new RemoveEnclosingBracesFormatter();

    private OOBibStyleGetCitationMarker() {
    }

    private static String getAuthorLastName(AuthorList authorList, int number) {
        StringBuilder stringBuilder = new StringBuilder();
        if (authorList.getNumberOfAuthors() > number) {
            Author author = authorList.getAuthor(number);
            Optional<String> von = author.getNamePrefix();
            if (von.isPresent() && !von.get().isEmpty()) {
                stringBuilder.append(von.get());
                stringBuilder.append(' ');
            }
            stringBuilder.append(author.getFamilyName().map(last -> REMOVE_BRACES_FORMATTER.format((String)last)).orElse(""));
        }
        return stringBuilder.toString();
    }

    private static String markupAuthorName(OOBibStyle style, String name) {
        return style.getAuthorNameMarkupBefore() + name + style.getAuthorNameMarkupAfter();
    }

    private static String formatAuthorList(OOBibStyle style, @NonNull AuthorList authorList, int maxAuthors, String andString) {
        int nAuthorsToEmit;
        boolean maxAuthorsBeforeEtAl = true;
        Object etAlString = style.getEtAlString();
        if (style.getItalicEtAl()) {
            etAlString = "<i>" + (String)etAlString + "</i>";
        }
        String authorSep = style.getAuthorSeparator();
        String oxfordComma = style.getOxfordComma();
        StringBuilder stringBuilder = new StringBuilder();
        int nAuthors = authorList.getNumberOfAuthors();
        if (maxAuthors == 0 && nAuthors != 0) {
            throw new IllegalArgumentException("maxAuthors = 0 in formatAuthorList");
        }
        if (maxAuthors < -1) {
            throw new IllegalArgumentException("maxAuthors < -1 in formatAuthorList");
        }
        boolean emitAllAuthors = nAuthors <= maxAuthors || maxAuthors == -1;
        int n = nAuthorsToEmit = emitAllAuthors ? nAuthors : Math.min(1, nAuthors);
        if (nAuthorsToEmit >= 1) {
            stringBuilder.append(style.getAuthorsPartMarkupBefore());
            stringBuilder.append(style.getAuthorNamesListMarkupBefore());
            String name = OOBibStyleGetCitationMarker.getAuthorLastName(authorList, 0);
            stringBuilder.append(OOBibStyleGetCitationMarker.markupAuthorName(style, name));
        }
        if (nAuthors >= 2 && emitAllAuthors) {
            String name;
            for (int j = 1; j < nAuthors - 1; ++j) {
                stringBuilder.append(authorSep);
                name = OOBibStyleGetCitationMarker.getAuthorLastName(authorList, j);
                stringBuilder.append(OOBibStyleGetCitationMarker.markupAuthorName(style, name));
            }
            if (nAuthors >= 3) {
                stringBuilder.append(oxfordComma);
            }
            stringBuilder.append(andString);
            name = OOBibStyleGetCitationMarker.getAuthorLastName(authorList, nAuthors - 1);
            stringBuilder.append(OOBibStyleGetCitationMarker.markupAuthorName(style, name));
        }
        if (nAuthorsToEmit >= 1) {
            stringBuilder.append(style.getAuthorNamesListMarkupAfter());
        }
        if (nAuthors >= 2 && !emitAllAuthors) {
            stringBuilder.append((String)etAlString);
        }
        stringBuilder.append(style.getAuthorsPartMarkupAfter());
        return stringBuilder.toString();
    }

    private static Optional<FieldAndContent> getRawCitationMarkerField(@NonNull BibEntry entry, @NonNull BibDatabase database, @NonNull OrFields fields) {
        for (Field field : fields.getFields()) {
            Optional<String> optionalContent = entry.getResolvedFieldOrAlias(field, database);
            boolean foundSomething = !StringUtil.isBlank(optionalContent);
            if (!foundSomething) continue;
            return Optional.of(new FieldAndContent(field, optionalContent.get()));
        }
        return Optional.empty();
    }

    private static String getCitationMarkerField(OOBibStyle style, @NonNull CitationLookupResult db, OrFields fields) {
        Optional<FieldAndContent> optionalFieldAndContent = OOBibStyleGetCitationMarker.getRawCitationMarkerField(db.entry, db.database, fields);
        if (optionalFieldAndContent.isEmpty()) {
            return "";
        }
        FieldAndContent fieldAndContent = optionalFieldAndContent.get();
        Object result = style.getFieldFormatter().format(fieldAndContent.content);
        OrFields fieldsToRebrace = style.getAuthorFieldNames();
        if (fieldsToRebrace.contains(fieldAndContent.field) && StringUtil.isInCurlyBrackets(fieldAndContent.content)) {
            result = "{" + (String)result + "}";
        }
        return result;
    }

    private static AuthorList getAuthorList(OOBibStyle style, CitationLookupResult db) {
        OrFields authorFieldNames = style.getAuthorFieldNames();
        String authorListAsString = OOBibStyleGetCitationMarker.getCitationMarkerField(style, db, authorFieldNames);
        return AuthorList.parse(authorListAsString);
    }

    private static int calculateNAuthorsToEmit(OOBibStyle style, CitationMarkerEntry entry) {
        if (entry.getLookupResult().isEmpty()) {
            return 0;
        }
        int maxAuthors = entry.getIsFirstAppearanceOfSource() ? style.getMaxAuthorsFirst() : style.getMaxAuthors();
        AuthorList authorList = OOBibStyleGetCitationMarker.getAuthorList(style, entry.getLookupResult().get());
        int nAuthors = authorList.getNumberOfAuthors();
        if (maxAuthors == -1) {
            return nAuthors;
        }
        return Integer.min(nAuthors, maxAuthors);
    }

    private static OOText getAuthorYearParenthesisMarker2(OOBibStyle style, AuthorYearMarkerPurpose purpose, List<CitationMarkerEntry> entries, boolean[] startsNewGroup, Optional<Integer> maxAuthorsOverride) {
        boolean inParenthesis = purpose == AuthorYearMarkerPurpose.IN_PARENTHESIS || purpose == AuthorYearMarkerPurpose.NORMALIZED;
        String yearSep = inParenthesis ? style.getYearSeparator() : style.getYearSeparatorInText();
        String startBrace = style.getBracketBefore();
        String endBrace = style.getBracketAfter();
        String citationSeparator = style.getCitationSeparator();
        OrFields yearFieldNames = style.getYearFieldNames();
        String andString = inParenthesis ? style.getAuthorLastSeparator() : style.getAuthorLastSeparatorInTextWithFallBack();
        String pageInfoSeparator = style.getPageInfoSeparator();
        String uniquefierSeparator = style.getUniquefierSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(style.getCitationGroupMarkupBefore());
        if (inParenthesis) {
            stringBuilder.append(startBrace);
        }
        for (int j = 0; j < entries.size(); ++j) {
            String uniqueLetter;
            String year;
            int maxAuthors;
            boolean isUnresolved;
            Optional<OOText> pageInfo;
            boolean endingAGroup;
            CitationMarkerEntry entry = entries.get(j);
            boolean startingNewGroup = startsNewGroup[j];
            boolean bl = endingAGroup = j + 1 == entries.size() || startsNewGroup[j + 1];
            if (!startingNewGroup) {
                String uniqueLetter2 = entry.getUniqueLetter().orElse(null);
                if (uniqueLetter2 != null) {
                    stringBuilder.append(uniquefierSeparator);
                    stringBuilder.append(uniqueLetter2);
                }
                if (inParenthesis || !endingAGroup) continue;
                stringBuilder.append(endBrace);
                continue;
            }
            if (j > 0) {
                stringBuilder.append(citationSeparator);
            }
            StringBuilder pageInfoPart = new StringBuilder("");
            if (purpose != AuthorYearMarkerPurpose.NORMALIZED && (pageInfo = PageInfo.normalizePageInfo(entry.getPageInfo())).isPresent()) {
                pageInfoPart.append(pageInfoSeparator);
                pageInfoPart.append(OOText.toString(pageInfo.get()));
            }
            if (isUnresolved = entry.getLookupResult().isEmpty()) {
                stringBuilder.append("Unresolved(%s)".formatted(entry.getCitationKey()));
                if (purpose == AuthorYearMarkerPurpose.NORMALIZED) continue;
                stringBuilder.append((CharSequence)pageInfoPart);
                continue;
            }
            CitationLookupResult db = entry.getLookupResult().get();
            int n = maxAuthors = purpose == AuthorYearMarkerPurpose.NORMALIZED ? style.getMaxAuthors() : OOBibStyleGetCitationMarker.calculateNAuthorsToEmit(style, entry);
            if (maxAuthorsOverride.isPresent()) {
                maxAuthors = maxAuthorsOverride.get();
            }
            AuthorList authorList = OOBibStyleGetCitationMarker.getAuthorList(style, db);
            String authorString = OOBibStyleGetCitationMarker.formatAuthorList(style, authorList, maxAuthors, andString);
            stringBuilder.append(authorString);
            stringBuilder.append(yearSep);
            if (!inParenthesis) {
                stringBuilder.append(startBrace);
            }
            if ((year = OOBibStyleGetCitationMarker.getCitationMarkerField(style, db, yearFieldNames)) != null) {
                stringBuilder.append(year);
            }
            if (purpose != AuthorYearMarkerPurpose.NORMALIZED && (uniqueLetter = (String)entry.getUniqueLetter().orElse(null)) != null) {
                stringBuilder.append(uniqueLetter);
            }
            if (purpose != AuthorYearMarkerPurpose.NORMALIZED) {
                stringBuilder.append((CharSequence)pageInfoPart);
            }
            if (inParenthesis || !endingAGroup) continue;
            stringBuilder.append(endBrace);
        }
        if (inParenthesis) {
            stringBuilder.append(endBrace);
        }
        stringBuilder.append(style.getCitationGroupMarkupAfter());
        return OOText.fromString(stringBuilder.toString());
    }

    static OOText getNormalizedCitationMarker(OOBibStyle style, CitationMarkerNormEntry normEntry, Optional<Integer> maxAuthorsOverride) {
        boolean[] startsNewGroup = new boolean[]{true};
        CitationMarkerNormEntryWrap entry = new CitationMarkerNormEntryWrap(normEntry);
        return OOBibStyleGetCitationMarker.getAuthorYearParenthesisMarker2(style, AuthorYearMarkerPurpose.NORMALIZED, Collections.singletonList(entry), startsNewGroup, maxAuthorsOverride);
    }

    private static List<OOText> getNormalizedCitationMarkers(OOBibStyle style, List<CitationMarkerEntry> citationMarkerEntries, Optional<Integer> maxAuthorsOverride) {
        ArrayList<OOText> normalizedMarkers = new ArrayList<OOText>(citationMarkerEntries.size());
        for (CitationMarkerEntry citationMarkerEntry : citationMarkerEntries) {
            OOText normalized = OOBibStyleGetCitationMarker.getNormalizedCitationMarker(style, citationMarkerEntry, maxAuthorsOverride);
            normalizedMarkers.add(normalized);
        }
        return normalizedMarkers;
    }

    public static OOText createCitationMarker(OOBibStyle style, List<CitationMarkerEntry> citationMarkerEntries, boolean inParenthesis, NonUniqueCitationMarker nonUniqueCitationMarkerHandling) {
        int nEntries = citationMarkerEntries.size();
        List<OOText> normalizedMarkers = OOBibStyleGetCitationMarker.getNormalizedCitationMarkers(style, citationMarkerEntries, Optional.empty());
        int[] nAuthorsToEmit = new int[nEntries];
        int[] nAuthorsToEmitRevised = new int[nEntries];
        for (int i = 0; i < nEntries; ++i) {
            int nAuthors;
            CitationMarkerEntry entry = citationMarkerEntries.get(i);
            nAuthorsToEmit[i] = nAuthors = OOBibStyleGetCitationMarker.calculateNAuthorsToEmit(style, entry);
            nAuthorsToEmitRevised[i] = nAuthors;
        }
        boolean[] startsNewGroup = new boolean[nEntries];
        ArrayList<CitationMarkerEntry> filteredCitationMarkerEntries = new ArrayList<CitationMarkerEntry>(nEntries);
        int i_out = 0;
        if (nEntries > 0) {
            filteredCitationMarkerEntries.add(citationMarkerEntries.getFirst());
            startsNewGroup[i_out] = true;
            ++i_out;
        }
        for (int i = 1; i < nEntries; ++i) {
            boolean sameAsPrev;
            boolean startingNewGroup;
            CitationMarkerEntry ce1 = citationMarkerEntries.get(i - 1);
            CitationMarkerEntry ce2 = citationMarkerEntries.get(i);
            String nm1 = OOText.toString(normalizedMarkers.get(i - 1));
            String nm2 = OOText.toString(normalizedMarkers.get(i));
            boolean isUnresolved1 = ce1.getLookupResult().isEmpty();
            boolean isUnresolved2 = ce2.getLookupResult().isEmpty();
            if (isUnresolved2) {
                startingNewGroup = true;
                sameAsPrev = false;
            } else {
                boolean uniqueLetterDoesNotMakeUnique;
                boolean nAuthorsShownInhibitsJoin;
                if (isUnresolved1) {
                    nAuthorsShownInhibitsJoin = true;
                } else {
                    boolean isFirst1 = ce1.getIsFirstAppearanceOfSource();
                    boolean isFirst2 = ce2.getIsFirstAppearanceOfSource();
                    if (!isFirst1 && !isFirst2 && nAuthorsToEmitRevised[i - 1] == nAuthorsToEmit[i - 1]) {
                        nAuthorsShownInhibitsJoin = false;
                    } else if (style.getMaxAuthors() == style.getMaxAuthorsFirst()) {
                        nAuthorsShownInhibitsJoin = false;
                    } else {
                        int prevShown = nAuthorsToEmitRevised[i - 1];
                        int need = nAuthorsToEmit[i];
                        if (prevShown < need) {
                            nAuthorsShownInhibitsJoin = true;
                        } else {
                            boolean extendedMarkersDiffer;
                            OOText nmx1 = OOBibStyleGetCitationMarker.getNormalizedCitationMarker(style, ce1, Optional.of(prevShown));
                            OOText nmx2 = OOBibStyleGetCitationMarker.getNormalizedCitationMarker(style, ce2, Optional.of(prevShown));
                            nAuthorsShownInhibitsJoin = extendedMarkersDiffer = !nmx2.equals(nmx1);
                        }
                    }
                }
                boolean citationKeysDiffer = !ce2.getCitationKey().equals(ce1.getCitationKey());
                boolean normalizedMarkersDiffer = !nm2.equals(nm1);
                Optional<OOText> pageInfo2 = PageInfo.normalizePageInfo(ce2.getPageInfo());
                Optional<OOText> pageInfo1 = PageInfo.normalizePageInfo(ce1.getPageInfo());
                boolean bothPageInfosAreEmpty = pageInfo2.isEmpty() && pageInfo1.isEmpty();
                boolean pageInfosDiffer = !pageInfo2.equals(pageInfo1);
                Optional<String> ul2 = ce2.getUniqueLetter();
                Optional<String> ul1 = ce1.getUniqueLetter();
                boolean uniqueLetterPresenceChanged = ul2.isPresent() != ul1.isPresent();
                boolean uniqueLettersDiffer = !ul2.equals(ul1);
                boolean bl = uniqueLetterDoesNotMakeUnique = citationKeysDiffer && !normalizedMarkersDiffer && !uniqueLettersDiffer;
                if (uniqueLetterDoesNotMakeUnique && nonUniqueCitationMarkerHandling == NonUniqueCitationMarker.THROWS) {
                    throw new IllegalArgumentException("different citation keys, but same normalizedMarker and uniqueLetter");
                }
                boolean pageInfoInhibitsJoin = bothPageInfosAreEmpty ? false : citationKeysDiffer || pageInfosDiffer;
                boolean bl2 = startingNewGroup = normalizedMarkersDiffer || nAuthorsShownInhibitsJoin || pageInfoInhibitsJoin || uniqueLetterPresenceChanged || uniqueLetterDoesNotMakeUnique;
                if (!startingNewGroup) {
                    nAuthorsToEmitRevised[i] = nAuthorsToEmitRevised[i - 1];
                }
                boolean bl3 = sameAsPrev = !startingNewGroup && !uniqueLettersDiffer && !citationKeysDiffer && !pageInfosDiffer;
            }
            if (sameAsPrev) continue;
            filteredCitationMarkerEntries.add(ce2);
            startsNewGroup[i_out] = startingNewGroup;
            ++i_out;
        }
        return OOBibStyleGetCitationMarker.getAuthorYearParenthesisMarker2(style, inParenthesis ? AuthorYearMarkerPurpose.IN_PARENTHESIS : AuthorYearMarkerPurpose.IN_TEXT, filteredCitationMarkerEntries, startsNewGroup, Optional.empty());
    }

    private static class FieldAndContent {
        Field field;
        String content;

        FieldAndContent(Field field, String content) {
            this.field = field;
            this.content = content;
        }
    }

    private static enum AuthorYearMarkerPurpose {
        IN_PARENTHESIS,
        IN_TEXT,
        NORMALIZED;

    }

    private static class CitationMarkerNormEntryWrap
    implements CitationMarkerEntry {
        CitationMarkerNormEntry inner;

        CitationMarkerNormEntryWrap(CitationMarkerNormEntry inner) {
            this.inner = inner;
        }

        @Override
        public String getCitationKey() {
            return this.inner.getCitationKey();
        }

        @Override
        public Optional<CitationLookupResult> getLookupResult() {
            return this.inner.getLookupResult();
        }

        @Override
        public Optional<String> getUniqueLetter() {
            return Optional.empty();
        }

        @Override
        public Optional<OOText> getPageInfo() {
            return Optional.empty();
        }

        @Override
        public boolean getIsFirstAppearanceOfSource() {
            return false;
        }
    }
}

