/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public class EntryLinkChecker
implements EntryChecker {
    private final BibDatabase database;

    public EntryLinkChecker(BibDatabase database) {
        this.database = Objects.requireNonNull(database);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (Map.Entry<Field, String> field : entry.getFieldMap().entrySet()) {
            EnumSet<FieldProperty> properties = field.getKey().getProperties();
            if (!properties.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK) && !properties.contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) continue;
            entry.getEntryLinkList(field.getKey(), this.database).stream().filter(parsedEntryLink -> parsedEntryLink.getLinkedEntry().isEmpty()).forEach(parsedEntryLink -> result.add(new IntegrityMessage(Localization.lang("Referenced citation key '%0' does not exist", parsedEntryLink.getKey()), entry, (Field)field.getKey())));
        }
        return result;
    }
}

