/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.importer.fetcher.transformers.DefaultQueryTransformer;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.layout.format.RTFChars;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResearchGate
implements FulltextFetcher,
EntryBasedFetcher,
SearchBasedFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResearchGate.class);
    private static final String HOST = "https://www.researchgate.net/";
    private static final String GOOGLE_SEARCH = "https://www.google.com/search?q=";
    private static final String GOOGLE_SITE = "%20site:researchgate.net";
    private static final String SEARCH = "https://www.researchgate.net/search.Search.html?";
    private static final String SEARCH_FOR_BIB_ENTRY = "https://www.researchgate.net/lite.publication.PublicationDownloadCitationModal.downloadCitation.html?fileType=BibTeX&citation=citationAndAbstract&publicationUid=";
    private final ImportFormatPreferences formatPreferences;

    public ResearchGate(ImportFormatPreferences importFormatPreferences) {
        this.formatPreferences = importFormatPreferences;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException, FetcherException {
        Document html;
        Objects.requireNonNull(entry);
        try {
            html = this.getHTML(entry);
        }
        catch (NullPointerException | FetcherException e) {
            LOGGER.debug("ResearchGate server is not available");
            return Optional.empty();
        }
        Elements eLink = html.getElementsByTag("section");
        String link = eLink.select("a[href^=https]").select("a[href$=.pdf]").attr("href");
        LOGGER.debug("PDF link: {}", (Object)link);
        if (link.contains("researchgate.net")) {
            return Optional.of(new URL(link));
        }
        return Optional.empty();
    }

    private Document getHTML(BibEntry entry) throws FetcherException, IOException {
        Optional<String> linkForSearch;
        Optional<String> title = entry.getField(StandardField.TITLE);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (title.isPresent()) {
            LOGGER.trace("Search by Title");
            linkForSearch = this.getURLByString(title.get());
            if (linkForSearch.isPresent()) {
                Connection connection = Jsoup.connect((String)linkForSearch.get());
                return connection.cookieStore(connection.cookieStore()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").referrer("www.google.com").ignoreHttpErrors(true).get();
            }
        }
        if (doi.isPresent()) {
            LOGGER.trace("Search by DOI");
            linkForSearch = this.getURLByDoi((DOI)doi.get());
            if (linkForSearch.isPresent()) {
                Connection connection = Jsoup.connect((String)linkForSearch.get());
                return connection.cookieStore(connection.cookieStore()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").ignoreHttpErrors(true).get();
            }
        }
        throw new FetcherException("Could not find a pdf");
    }

    Optional<String> getURLByString(String query) throws IOException, NullPointerException {
        Object link;
        try {
            URIBuilder source = new URIBuilder(SEARCH);
            source.addParameter("type", "publication");
            source.addParameter("query", query);
            URLDownload urlDownload = new URLDownload(source.toString());
            urlDownload.getCookieFromUrl();
            Document html = Jsoup.connect((String)source.toString()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").referrer("www.google.com").ignoreHttpErrors(true).get();
            link = HOST + Objects.requireNonNull(html.getElementById("content")).select("a[href^=publication/]").attr("href");
            if (((String)link).contains("?")) {
                link = ((String)link).substring(0, ((String)link).indexOf("?"));
            }
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
        LOGGER.trace("URL for page: {}", link);
        return Optional.of(link);
    }

    Optional<String> getURLByDoi(DOI doi) throws IOException, NullPointerException {
        String link;
        try {
            URIBuilder source = new URIBuilder(SEARCH);
            source.addParameter("type", "publication");
            source.addParameter("query", doi.getDOI());
            source = new URIBuilder(GOOGLE_SEARCH + doi.getDOI() + GOOGLE_SITE);
            Connection connection = Jsoup.connect((String)source.toString());
            Document html = connection.cookieStore(connection.cookieStore()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").ignoreHttpErrors(true).get();
            link = Objects.requireNonNull(html.getElementById("search")).select("a").attr("href");
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
        LOGGER.trace("URL for page: {}", (Object)link);
        return Optional.of(link);
    }

    private Document getPage(QueryNode luceneQuery) throws URISyntaxException, IOException {
        String query = new DefaultQueryTransformer().transformLuceneQuery(luceneQuery).orElse("");
        URIBuilder source = new URIBuilder(SEARCH);
        source.addParameter("type", "publication");
        source.addParameter("query", query);
        return Jsoup.connect((String)source.build().toString()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").referrer("www.google.com").ignoreHttpErrors(true).get();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.META_SEARCH;
    }

    @Override
    public List<BibEntry> performSearch(QueryNode luceneQuery) throws FetcherException {
        Document html;
        try {
            html = this.getPage(luceneQuery);
            if (!html.getElementsByClass("nova-legacy-v-publication-item__title").hasText()) {
                throw new FetcherException("ResearchGate server unavailable");
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new FetcherException("URL is not correct", e);
        }
        Elements sol = html.getElementsByClass("nova-legacy-v-publication-item__title");
        List<String> urls = sol.select("a").eachAttr("href").stream().filter(stream -> stream.contains("publication/")).map(resultStream -> resultStream.substring(resultStream.indexOf("publication/") + 12, resultStream.indexOf("_"))).map(idStream -> SEARCH_FOR_BIB_ENTRY + idStream).map(this::getInputStream).filter(Objects::nonNull).map(stream -> stream.lines().collect(Collectors.joining(OS.NEWLINE))).toList();
        ArrayList<BibEntry> list = new ArrayList<BibEntry>();
        for (String bib : urls) {
            BibtexParser parser = new BibtexParser(this.formatPreferences);
            try {
                Optional<BibEntry> entry = parser.parseSingleEntry(bib);
                entry.ifPresent(list::add);
            }
            catch (ParseException e) {
                LOGGER.debug("Entry is not convertible to Bibtex", (Throwable)e);
            }
        }
        return list;
    }

    private BufferedReader getInputStream(String urlString) {
        try {
            URL url = new URL(urlString);
            return new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (IOException e) {
            LOGGER.debug("Wrong URL:", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return "ResearchGate";
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> title = entry.getTitle();
        if (title.isEmpty()) {
            return new ArrayList<BibEntry>();
        }
        return this.performSearch(new RTFChars().format(title.get()));
    }
}

