/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.bibtex.comparator.FieldComparatorStack;
import org.jabref.logic.layout.format.GetOpenOfficeType;
import org.jabref.logic.layout.format.RemoveBrackets;
import org.jabref.logic.layout.format.RemoveWhitespace;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class OpenDocumentRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenDocumentRepresentation.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final List<BibEntry> entries;
    private final BibDatabase database;

    public OpenDocumentRepresentation(BibDatabase database, List<BibEntry> entries) {
        this.database = database;
        ArrayList<FieldComparator> comparators = new ArrayList<FieldComparator>();
        comparators.add(new FieldComparator(StandardField.AUTHOR));
        comparators.add(new FieldComparator(StandardField.YEAR));
        comparators.add(new FieldComparator(InternalField.KEY_FIELD));
        ArrayList<BibEntry> entryList = new ArrayList<BibEntry>();
        if (entries == null) {
            entryList.addAll((Collection<BibEntry>)database.getEntries());
        } else {
            entryList.addAll(entries);
        }
        Collections.sort(entryList, new FieldComparatorStack(comparators));
        this.entries = entryList;
    }

    public Document getDOMrepresentation() {
        Document result = null;
        try {
            DocumentBuilder dbuild = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            result = dbuild.newDocument();
            Element collection = result.createElement("office:document-content");
            collection.setAttribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
            collection.setAttribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            collection.setAttribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            collection.setAttribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            collection.setAttribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            collection.setAttribute("office:version", "1.0");
            collection.setAttribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
            collection.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            Element el = result.createElement("office:scripts");
            collection.appendChild(el);
            el = result.createElement("office:automatic-styles");
            Element el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ro1");
            el2.setAttribute("style:family", "table-row");
            Element el3 = result.createElement("style.table-row-properties");
            el3.setAttribute("style:row-height", "0.1681inch");
            el3.setAttribute("fo:break-before", "auto");
            el3.setAttribute("style:use-optimal-row-height", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ta1");
            el2.setAttribute("style:family", "table");
            el2.setAttribute("style:master-page-name", "Default");
            el3 = result.createElement("style:properties");
            el3.setAttribute("table:display", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            collection.appendChild(el);
            Element body = result.createElement("office:body");
            Element spreadsheet = result.createElement("office:spreadsheet");
            Element table = result.createElement("table:table");
            table.setAttribute("table:name", "biblio");
            table.setAttribute("table.style-name", "ta1");
            Element row = result.createElement("table:table-row");
            row.setAttribute("table.style-name", "ro1");
            this.addTableCell(result, row, "Identifier");
            this.addTableCell(result, row, "Type");
            this.addTableCell(result, row, "Address");
            this.addTableCell(result, row, "Assignee");
            this.addTableCell(result, row, "Annote");
            this.addTableCell(result, row, "Author");
            this.addTableCell(result, row, "Booktitle");
            this.addTableCell(result, row, "Chapter");
            this.addTableCell(result, row, "Day");
            this.addTableCell(result, row, "Dayfiled");
            this.addTableCell(result, row, "Edition");
            this.addTableCell(result, row, "Editor");
            this.addTableCell(result, row, "Howpublish");
            this.addTableCell(result, row, "Institution");
            this.addTableCell(result, row, "Journal");
            this.addTableCell(result, row, "Language");
            this.addTableCell(result, row, "Month");
            this.addTableCell(result, row, "Monthfiled");
            this.addTableCell(result, row, "Nationality");
            this.addTableCell(result, row, "Note");
            this.addTableCell(result, row, "Number");
            this.addTableCell(result, row, "Organization");
            this.addTableCell(result, row, "Pages");
            this.addTableCell(result, row, "Publisher");
            this.addTableCell(result, row, "Revision");
            this.addTableCell(result, row, "School");
            this.addTableCell(result, row, "Series");
            this.addTableCell(result, row, "Title");
            this.addTableCell(result, row, "RepType");
            this.addTableCell(result, row, "Volume");
            this.addTableCell(result, row, "Year");
            this.addTableCell(result, row, "Yearfiled");
            this.addTableCell(result, row, "URL");
            this.addTableCell(result, row, "Custom1");
            this.addTableCell(result, row, "Custom2");
            this.addTableCell(result, row, "Custom3");
            this.addTableCell(result, row, "Custom4");
            this.addTableCell(result, row, "Custom5");
            this.addTableCell(result, row, "ISBN");
            table.appendChild(row);
            for (BibEntry e : this.entries) {
                row = result.createElement("table:table-row");
                this.addTableCell(result, row, this.getField(e, InternalField.KEY_FIELD));
                this.addTableCell(result, row, new GetOpenOfficeType().format(e.getType().getName()));
                this.addTableCell(result, row, this.getField(e, StandardField.ADDRESS));
                this.addTableCell(result, row, this.getField(e, StandardField.ASSIGNEE));
                this.addTableCell(result, row, this.getField(e, StandardField.ANNOTE));
                this.addTableCell(result, row, this.getField(e, StandardField.AUTHOR));
                this.addTableCell(result, row, this.getField(e, StandardField.BOOKTITLE));
                this.addTableCell(result, row, this.getField(e, StandardField.CHAPTER));
                this.addTableCell(result, row, this.getField(e, StandardField.DAY));
                this.addTableCell(result, row, this.getField(e, StandardField.DAYFILED));
                this.addTableCell(result, row, this.getField(e, StandardField.EDITION));
                this.addTableCell(result, row, this.getField(e, StandardField.EDITOR));
                this.addTableCell(result, row, this.getField(e, StandardField.HOWPUBLISHED));
                this.addTableCell(result, row, this.getField(e, StandardField.INSTITUTION));
                this.addTableCell(result, row, this.getField(e, StandardField.JOURNAL));
                this.addTableCell(result, row, this.getField(e, StandardField.LANGUAGE));
                this.addTableCell(result, row, this.getField(e, StandardField.MONTH));
                this.addTableCell(result, row, this.getField(e, StandardField.MONTHFILED));
                this.addTableCell(result, row, this.getField(e, StandardField.NATIONALITY));
                this.addTableCell(result, row, this.getField(e, StandardField.NOTE));
                this.addTableCell(result, row, this.getField(e, StandardField.NUMBER));
                this.addTableCell(result, row, this.getField(e, StandardField.ORGANIZATION));
                this.addTableCell(result, row, this.getField(e, StandardField.PAGES));
                this.addTableCell(result, row, this.getField(e, StandardField.PUBLISHER));
                this.addTableCell(result, row, this.getField(e, StandardField.REVISION));
                this.addTableCell(result, row, this.getField(e, StandardField.SCHOOL));
                this.addTableCell(result, row, this.getField(e, StandardField.SERIES));
                this.addTableCell(result, row, new RemoveWhitespace().format(new RemoveBrackets().format(this.getField(e, StandardField.TITLE))));
                this.addTableCell(result, row, this.getField(e, new UnknownField("reporttype")));
                this.addTableCell(result, row, this.getField(e, StandardField.VOLUME));
                this.addTableCell(result, row, this.getField(e, StandardField.YEAR));
                this.addTableCell(result, row, this.getField(e, StandardField.YEARFILED));
                this.addTableCell(result, row, this.getField(e, StandardField.URL));
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, this.getField(e, StandardField.ISBN));
                table.appendChild(row);
            }
            spreadsheet.appendChild(table);
            body.appendChild(spreadsheet);
            collection.appendChild(body);
            result.appendChild(collection);
        }
        catch (Exception e) {
            LOGGER.warn("Exception caught...", (Throwable)e);
        }
        return result;
    }

    private String getField(BibEntry e, Field field) {
        return e.getResolvedFieldOrAlias(field, this.database).orElse("");
    }

    private void addTableCell(Document doc, Element parent, String content) {
        Element cell = doc.createElement("table:table-cell");
        Element text = doc.createElement("text:p");
        Text textNode = doc.createTextNode(content);
        text.appendChild(textNode);
        cell.appendChild(text);
        parent.appendChild(cell);
    }
}

