/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import de.undercouch.citeproc.AbbreviationProvider;
import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.DefaultAbbreviationProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.output.Bibliography;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.citationstyle.JabRefItemDataProvider;
import org.jabref.logic.citationstyle.JabRefLocaleProvider;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;

public class CSLAdapter {
    private final JabRefItemDataProvider dataProvider = new JabRefItemDataProvider();
    private String style;
    private CitationStyleOutputFormat format;
    private CSL cslInstance;

    public synchronized List<String> makeBibliography(List<BibEntry> bibEntries, String style, CitationStyleOutputFormat outputFormat, BibDatabaseContext databaseContext, BibEntryTypesManager entryTypesManager) throws IOException, IllegalArgumentException {
        this.dataProvider.setData(bibEntries, databaseContext, entryTypesManager);
        this.initialize(style, outputFormat);
        this.cslInstance.registerCitationItems(this.dataProvider.getIds());
        Bibliography bibliography = this.cslInstance.makeBibliography();
        return Arrays.asList(bibliography.getEntries());
    }

    private void initialize(String newStyle, CitationStyleOutputFormat newFormat) throws IOException {
        boolean newCslInstanceNeedsToBeCreated;
        boolean bl = newCslInstanceNeedsToBeCreated = this.cslInstance == null || !Objects.equals(newStyle, this.style);
        if (newCslInstanceNeedsToBeCreated) {
            this.cslInstance = new CSL((ItemDataProvider)this.dataProvider, (LocaleProvider)new JabRefLocaleProvider(), (AbbreviationProvider)new DefaultAbbreviationProvider(), newStyle, "en-US");
            this.style = newStyle;
        }
        if (newCslInstanceNeedsToBeCreated || !Objects.equals((Object)newFormat, (Object)this.format)) {
            this.cslInstance.setOutputFormat(newFormat.getFormat());
            this.format = newFormat;
        }
    }
}

