/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.shared;

import com.airhacks.afterburner.injection.Injector;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javax.swing.undo.UndoManager;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.exporter.SaveDatabaseAction;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.shared.SharedDatabaseUIManager;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DBMSConnectionProperties;
import org.jabref.logic.shared.DBMSConnectionPropertiesBuilder;
import org.jabref.logic.shared.DBMSType;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.shared.DatabaseNotSupportedException;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.logic.shared.security.Password;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedDatabaseLoginDialogViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedDatabaseLoginDialogViewModel.class);
    private final ObjectProperty<DBMSType> selectedDBMSType = new SimpleObjectProperty((Object)DBMSType.values()[0]);
    private final StringProperty database = new SimpleStringProperty("");
    private final StringProperty host = new SimpleStringProperty("");
    private final StringProperty port = new SimpleStringProperty("");
    private final StringProperty user = new SimpleStringProperty("");
    private final StringProperty password = new SimpleStringProperty("");
    private final StringProperty folder = new SimpleStringProperty("");
    private final BooleanProperty autosave = new SimpleBooleanProperty();
    private final BooleanProperty rememberPassword = new SimpleBooleanProperty();
    private final BooleanProperty loading = new SimpleBooleanProperty();
    private final StringProperty keystore = new SimpleStringProperty("");
    private final BooleanProperty useSSL = new SimpleBooleanProperty();
    private final StringProperty keyStorePasswordProperty = new SimpleStringProperty("");
    private final StringProperty serverTimezone = new SimpleStringProperty("");
    private final BooleanProperty expertMode = new SimpleBooleanProperty();
    private final StringProperty jdbcUrl = new SimpleStringProperty("");
    private final LibraryTabContainer tabContainer;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final SharedDatabasePreferences sharedDatabasePreferences = new SharedDatabasePreferences();
    private final StateManager stateManager;
    private final BibEntryTypesManager entryTypesManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final UndoManager undoManager;
    private final ClipBoardManager clipBoardManager;
    private final TaskExecutor taskExecutor;
    private final Validator databaseValidator;
    private final Validator hostValidator;
    private final Validator portValidator;
    private final Validator userValidator;
    private final Validator folderValidator;
    private final Validator keystoreValidator;
    private final CompositeValidator formValidator;

    public SharedDatabaseLoginDialogViewModel(LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, BibEntryTypesManager entryTypesManager, FileUpdateMonitor fileUpdateMonitor, UndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        this.tabContainer = tabContainer;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.entryTypesManager = entryTypesManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.undoManager = undoManager;
        this.clipBoardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
        EasyBind.subscribe(this.selectedDBMSType, selected -> this.port.setValue(Integer.toString(selected.getDefaultPort())));
        Predicate<String> notEmpty = input -> input != null && !input.trim().isEmpty();
        Predicate<String> fileExists = input -> Files.exists(Path.of(input, new String[0]), new LinkOption[0]);
        Predicate<String> notEmptyAndfilesExist = notEmpty.and(fileExists);
        this.databaseValidator = new FunctionBasedValidator((ObservableValue)this.database, notEmpty, ValidationMessage.error((String)Localization.lang("Required field \"%0\" is empty.", Localization.lang("Library", new Object[0]))));
        this.hostValidator = new FunctionBasedValidator((ObservableValue)this.host, notEmpty, ValidationMessage.error((String)Localization.lang("Required field \"%0\" is empty.", Localization.lang("Port", new Object[0]))));
        this.portValidator = new FunctionBasedValidator((ObservableValue)this.port, notEmpty, ValidationMessage.error((String)Localization.lang("Required field \"%0\" is empty.", Localization.lang("Host", new Object[0]))));
        this.userValidator = new FunctionBasedValidator((ObservableValue)this.user, notEmpty, ValidationMessage.error((String)Localization.lang("Required field \"%0\" is empty.", Localization.lang("User", new Object[0]))));
        this.folderValidator = new FunctionBasedValidator((ObservableValue)this.folder, notEmptyAndfilesExist, ValidationMessage.error((String)Localization.lang("Please enter a valid file path.", new Object[0])));
        this.keystoreValidator = new FunctionBasedValidator((ObservableValue)this.keystore, notEmptyAndfilesExist, ValidationMessage.error((String)Localization.lang("Please enter a valid file path.", new Object[0])));
        this.formValidator = new CompositeValidator();
        this.formValidator.addValidators(new Validator[]{this.databaseValidator, this.hostValidator, this.portValidator, this.userValidator});
        this.applyPreferences();
    }

    public boolean openDatabase() {
        DBMSConnectionProperties connectionProperties = new DBMSConnectionPropertiesBuilder().setType((DBMSType)((Object)this.selectedDBMSType.getValue())).setHost(this.host.getValue()).setPort(Integer.parseInt(this.port.getValue())).setDatabase(this.database.getValue()).setUser(this.user.getValue()).setPassword(this.password.getValue()).setUseSSL(this.useSSL.getValue()).setAllowPublicKeyRetrieval(true).setKeyStore(this.keystore.getValue()).setServerTimezone(this.serverTimezone.getValue()).setExpertMode(this.expertMode.getValue()).setJdbcUrl(this.jdbcUrl.getValue()).createDBMSConnectionProperties();
        this.setupKeyStore();
        return this.openSharedDatabase(connectionProperties);
    }

    private void setupKeyStore() {
        System.setProperty("javax.net.ssl.trustStore", this.keystore.getValue());
        System.setProperty("javax.net.ssl.trustStorePassword", this.keyStorePasswordProperty.getValue());
        System.setProperty("javax.net.debug", "ssl");
    }

    private boolean openSharedDatabase(DBMSConnectionProperties connectionProperties) {
        boolean overwriteFilePressed;
        Path localFilePath;
        if (this.isSharedDatabaseAlreadyPresent(connectionProperties)) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Shared database connection", new Object[0]), Localization.lang("You are already connected to a database using entered connection details.", new Object[0]));
            return true;
        }
        if (this.autosave.get() && Files.exists(localFilePath = Path.of(this.folder.getValue(), new String[0]), new LinkOption[0]) && !Files.isDirectory(localFilePath, new LinkOption[0]) && !(overwriteFilePressed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Existing file", new Object[0]), Localization.lang("'%0' exists. Overwrite file?", localFilePath.getFileName().toString()), Localization.lang("Overwrite file", new Object[0]), Localization.lang("Cancel", new Object[0])))) {
            return true;
        }
        this.loading.set(true);
        try {
            SharedDatabaseUIManager manager = new SharedDatabaseUIManager(this.tabContainer, this.dialogService, this.preferencesService, this.stateManager, this.entryTypesManager, this.fileUpdateMonitor, this.undoManager, this.clipBoardManager, this.taskExecutor);
            LibraryTab libraryTab = manager.openNewSharedDatabaseTab(connectionProperties);
            this.setPreferences();
            if (!this.folder.getValue().isEmpty() && this.autosave.get()) {
                try {
                    new SaveDatabaseAction(libraryTab, this.dialogService, this.preferencesService, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class)).saveAs(Path.of(this.folder.getValue(), new String[0]));
                }
                catch (Throwable e) {
                    LOGGER.error("Error while saving the database", e);
                }
            }
            return true;
        }
        catch (SQLException | InvalidDBMSConnectionPropertiesException exception) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Connection error", new Object[0]), exception);
        }
        catch (DatabaseNotSupportedException exception) {
            ButtonType openHelp = new ButtonType("Open Help", ButtonBar.ButtonData.OTHER);
            Optional<ButtonType> result = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.INFORMATION, Localization.lang("Migration help information", new Object[0]), Localization.lang("Entered database has obsolete structure and is no longer supported.", new Object[0]) + "\n" + Localization.lang("Click help to learn about the migration of pre-3.6 databases.", new Object[0]) + "\n" + Localization.lang("However, a new database was created alongside the pre-3.6 one.", new Object[0]), ButtonType.OK, openHelp);
            result.filter(btn -> btn.equals(openHelp)).ifPresent(btn -> new HelpAction(HelpFile.SQL_DATABASE_MIGRATION, this.dialogService, this.preferencesService.getFilePreferences()).execute());
            result.filter(btn -> btn.equals(ButtonType.OK)).ifPresent(btn -> this.openSharedDatabase(connectionProperties));
        }
        this.loading.set(false);
        return false;
    }

    private void setPreferences() {
        this.sharedDatabasePreferences.setType(((DBMSType)((Object)this.selectedDBMSType.getValue())).toString());
        this.sharedDatabasePreferences.setHost(this.host.getValue());
        this.sharedDatabasePreferences.setPort(this.port.getValue());
        this.sharedDatabasePreferences.setName(this.database.getValue());
        this.sharedDatabasePreferences.setUser(this.user.getValue());
        this.sharedDatabasePreferences.setUseSSL(this.useSSL.getValue());
        this.sharedDatabasePreferences.setKeystoreFile(this.keystore.getValue());
        this.sharedDatabasePreferences.setServerTimezone(this.serverTimezone.getValue());
        if (this.rememberPassword.get()) {
            try {
                this.sharedDatabasePreferences.setPassword(new Password(this.password.getValue(), this.user.getValue()).encrypt());
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LOGGER.error("Could not store the password due to encryption problems.", (Throwable)e);
            }
        } else {
            this.sharedDatabasePreferences.clearPassword();
        }
        this.sharedDatabasePreferences.setRememberPassword(this.rememberPassword.get());
        this.sharedDatabasePreferences.setFolder(this.folder.getValue());
        this.sharedDatabasePreferences.setAutosave(this.autosave.get());
    }

    private void applyPreferences() {
        Optional<String> sharedDatabaseType = this.sharedDatabasePreferences.getType();
        Optional<String> sharedDatabaseHost = this.sharedDatabasePreferences.getHost();
        Optional<String> sharedDatabasePort = this.sharedDatabasePreferences.getPort();
        Optional<String> sharedDatabaseName = this.sharedDatabasePreferences.getName();
        Optional<String> sharedDatabaseUser = this.sharedDatabasePreferences.getUser();
        Optional<String> sharedDatabasePassword = this.sharedDatabasePreferences.getPassword();
        boolean sharedDatabaseRememberPassword = this.sharedDatabasePreferences.getRememberPassword();
        Optional<String> sharedDatabaseFolder = this.sharedDatabasePreferences.getFolder();
        boolean sharedDatabaseAutosave = this.sharedDatabasePreferences.getAutosave();
        Optional<String> sharedDatabaseKeystoreFile = this.sharedDatabasePreferences.getKeyStoreFile();
        if (sharedDatabaseType.isPresent()) {
            Optional<DBMSType> dbmsType = DBMSType.fromString(sharedDatabaseType.get());
            dbmsType.ifPresent(arg_0 -> this.selectedDBMSType.set(arg_0));
        }
        sharedDatabaseHost.ifPresent(arg_0 -> ((StringProperty)this.host).set(arg_0));
        sharedDatabasePort.ifPresent(arg_0 -> ((StringProperty)this.port).set(arg_0));
        sharedDatabaseName.ifPresent(arg_0 -> ((StringProperty)this.database).set(arg_0));
        sharedDatabaseUser.ifPresent(arg_0 -> ((StringProperty)this.user).set(arg_0));
        sharedDatabaseKeystoreFile.ifPresent(arg_0 -> ((StringProperty)this.keystore).set(arg_0));
        this.useSSL.setValue(Boolean.valueOf(this.sharedDatabasePreferences.isUseSSL()));
        if (sharedDatabasePassword.isPresent() && sharedDatabaseUser.isPresent()) {
            try {
                this.password.setValue(new Password(sharedDatabasePassword.get().toCharArray(), sharedDatabaseUser.get()).decrypt());
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LOGGER.error("Could not read the password due to decryption problems.", (Throwable)e);
            }
        }
        this.rememberPassword.set(sharedDatabaseRememberPassword);
        sharedDatabaseFolder.ifPresent(arg_0 -> ((StringProperty)this.folder).set(arg_0));
        this.autosave.set(sharedDatabaseAutosave);
    }

    private boolean isSharedDatabaseAlreadyPresent(DBMSConnectionProperties connectionProperties) {
        List<LibraryTab> libraryTabs = this.tabContainer.getLibraryTabs();
        return libraryTabs.parallelStream().anyMatch(panel -> {
            BibDatabaseContext context = panel.getBibDatabaseContext();
            return context.getLocation() == DatabaseLocation.SHARED && connectionProperties.equals(context.getDBMSSynchronizer().getConnectionProperties());
        });
    }

    public void showSaveDbToFileDialog() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BIBTEX_DB).withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(this.preferencesService.getFilePreferences().getWorkingDirectory()).build();
        Optional<Path> exportPath = this.dialogService.showFileSaveDialog(fileDialogConfiguration);
        exportPath.ifPresent(path -> this.folder.setValue(path.toString()));
    }

    public void showOpenKeystoreFileDialog() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(FileFilterConverter.ANY_FILE).addExtensionFilter(StandardFileType.JAVA_KEYSTORE).withDefaultExtension(StandardFileType.JAVA_KEYSTORE).withInitialDirectory(this.preferencesService.getFilePreferences().getWorkingDirectory()).build();
        Optional<Path> keystorePath = this.dialogService.showFileOpenDialog(fileDialogConfiguration);
        keystorePath.ifPresent(path -> this.keystore.setValue(path.toString()));
    }

    public StringProperty databaseproperty() {
        return this.database;
    }

    public StringProperty hostProperty() {
        return this.host;
    }

    public StringProperty portProperty() {
        return this.port;
    }

    public StringProperty userProperty() {
        return this.user;
    }

    public StringProperty passwordProperty() {
        return this.password;
    }

    public BooleanProperty autosaveProperty() {
        return this.autosave;
    }

    public BooleanProperty rememberPasswordProperty() {
        return this.rememberPassword;
    }

    public StringProperty folderProperty() {
        return this.folder;
    }

    public StringProperty keyStoreProperty() {
        return this.keystore;
    }

    public StringProperty keyStorePasswordProperty() {
        return this.keyStorePasswordProperty;
    }

    public BooleanProperty useSSLProperty() {
        return this.useSSL;
    }

    public ObjectProperty<DBMSType> selectedDbmstypeProperty() {
        return this.selectedDBMSType;
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public ValidationStatus dbValidation() {
        return this.databaseValidator.getValidationStatus();
    }

    public ValidationStatus hostValidation() {
        return this.hostValidator.getValidationStatus();
    }

    public ValidationStatus portValidation() {
        return this.portValidator.getValidationStatus();
    }

    public ValidationStatus userValidation() {
        return this.userValidator.getValidationStatus();
    }

    public ValidationStatus folderValidation() {
        return this.folderValidator.getValidationStatus();
    }

    public ValidationStatus keystoreValidation() {
        return this.keystoreValidator.getValidationStatus();
    }

    public ValidationStatus formValidation() {
        return this.formValidator.getValidationStatus();
    }

    public StringProperty serverTimezoneProperty() {
        return this.serverTimezone;
    }

    public BooleanProperty expertModeProperty() {
        return this.expertMode;
    }

    public StringProperty jdbcUrlProperty() {
        return this.jdbcUrl;
    }
}

