/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.externalfiletypes;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.externalfiletype.CustomExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;

public class ExternalFileTypeItemViewModel {
    private final ObjectProperty<JabRefIcon> icon = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty extension = new SimpleStringProperty();
    private final StringProperty mimetype = new SimpleStringProperty();
    private final StringProperty application = new SimpleStringProperty();

    public ExternalFileTypeItemViewModel(ExternalFileType fileType) {
        this.icon.setValue((Object)fileType.getIcon());
        this.name.setValue(fileType.getName());
        this.extension.setValue(fileType.getExtension());
        this.mimetype.setValue(fileType.getMimeType());
        this.application.setValue(fileType.getOpenWithApplication());
    }

    public ExternalFileTypeItemViewModel() {
        this(new CustomExternalFileType("", "", "", "", "new", IconTheme.JabRefIcons.FILE));
    }

    public ObjectProperty<JabRefIcon> iconProperty() {
        return this.icon;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty extensionProperty() {
        return this.extension;
    }

    public StringProperty mimetypeProperty() {
        return this.mimetype;
    }

    public StringProperty applicationProperty() {
        return this.application;
    }

    public ExternalFileType toExternalFileType() {
        return new CustomExternalFileType((String)this.name.get(), (String)this.extension.get(), (String)this.mimetype.get(), (String)this.application.get(), ((JabRefIcon)this.icon.get()).name(), (JabRefIcon)this.icon.get());
    }
}

