/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.citationkeypattern;

import com.airhacks.afterburner.injection.Injector;
import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanel;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.citationkeypattern.CitationKeyPatternTabViewModel;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntryTypesManager;

public class CitationKeyPatternTab
extends AbstractPreferenceTabView<CitationKeyPatternTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox overwriteAllow;
    @FXML
    private CheckBox overwriteWarning;
    @FXML
    private CheckBox generateOnSave;
    @FXML
    private RadioButton letterStartA;
    @FXML
    private RadioButton letterStartB;
    @FXML
    private RadioButton letterAlwaysAdd;
    @FXML
    private TextField keyPatternRegex;
    @FXML
    private TextField keyPatternReplacement;
    @FXML
    private TextField unwantedCharacters;
    @FXML
    private Button keyPatternHelp;
    @FXML
    private CitationKeyPatternsPanel bibtexKeyPatternTable;

    public CitationKeyPatternTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Citation key generator", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new CitationKeyPatternTabViewModel(this.preferencesService.getCitationKeyPatternPreferences());
        this.overwriteAllow.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).overwriteAllowProperty());
        this.overwriteWarning.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).overwriteWarningProperty());
        this.generateOnSave.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).generateOnSaveProperty());
        this.letterStartA.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).letterStartAProperty());
        this.letterStartB.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).letterStartBProperty());
        this.letterAlwaysAdd.selectedProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).letterAlwaysAddProperty());
        this.keyPatternRegex.textProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).keyPatternRegexProperty());
        this.keyPatternReplacement.textProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).keyPatternReplacementProperty());
        this.unwantedCharacters.textProperty().bindBidirectional((Property)((CitationKeyPatternTabViewModel)this.viewModel).unwantedCharactersProperty());
        this.bibtexKeyPatternTable.patternListProperty().bindBidirectional(((CitationKeyPatternTabViewModel)this.viewModel).patternListProperty());
        this.bibtexKeyPatternTable.defaultKeyPatternProperty().bindBidirectional(((CitationKeyPatternTabViewModel)this.viewModel).defaultKeyPatternProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_KEY_PATTERNS, (Command)new HelpAction(HelpFile.CITATION_KEY_PATTERN, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.keyPatternHelp);
    }

    @Override
    public void setValues() {
        ((CitationKeyPatternTabViewModel)this.viewModel).setValues();
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        this.bibtexKeyPatternTable.setValues(entryTypesManager.getAllTypes(this.preferencesService.getLibraryPreferences().getDefaultBibDatabaseMode()), this.preferencesService.getCitationKeyPatternPreferences().getKeyPatterns());
    }

    @Override
    public void storeSettings() {
        ((CitationKeyPatternTabViewModel)this.viewModel).storeSettings();
    }

    @FXML
    public void resetAllKeyPatterns() {
        this.bibtexKeyPatternTable.resetAll();
    }
}

