/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import java.util.function.Supplier;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.exporter.SaveDatabaseAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public class SaveAllAction
extends SimpleCommand {
    private final Supplier<List<LibraryTab>> tabsSupplier;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;

    public SaveAllAction(Supplier<List<LibraryTab>> tabsSupplier, PreferencesService preferencesService, DialogService dialogService) {
        this.tabsSupplier = tabsSupplier;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
    }

    public void execute() {
        this.dialogService.notify(Localization.lang("Saving all libraries...", new Object[0]));
        for (LibraryTab libraryTab : this.tabsSupplier.get()) {
            SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction(libraryTab, this.dialogService, this.preferencesService, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
            boolean saveResult = saveDatabaseAction.save();
            if (saveResult) continue;
            this.dialogService.notify(Localization.lang("Could not save file.", new Object[0]));
        }
        this.dialogService.notify(Localization.lang("Save all finished.", new Object[0]));
    }
}

