/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SequencedSet;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.OrFields;
import org.jabref.preferences.PreferencesService;

public class RequiredFieldsTab
extends FieldsEditorTab {
    public static final String NAME = "Required fields";
    private final BibEntryTypesManager entryTypesManager;

    public RequiredFieldsTab(BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        super(false, databaseContext, suggestionProviders, undoManager, undoAction, redoAction, dialogService, preferences, stateManager, themeManager, taskExecutor, journalAbbreviationRepository, indexingTaskManager);
        this.entryTypesManager = entryTypesManager;
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show required fields", new Object[0])));
        this.setGraphic(IconTheme.JabRefIcons.REQUIRED.getGraphicNode());
    }

    @Override
    protected SequencedSet<Field> determineFieldsToShow(BibEntry entry) {
        Optional<BibEntryType> entryType = this.entryTypesManager.enrich(entry.getType(), this.databaseContext.getMode());
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        if (entryType.isPresent()) {
            for (OrFields orFields : entryType.get().getRequiredFields()) {
                fields.addAll(orFields.getFields());
            }
            fields.add(InternalField.KEY_FIELD);
        } else {
            fields.addAll(entry.getFields());
        }
        return fields;
    }
}

