/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeDetailsView;
import org.jabref.gui.collab.DatabaseChangeDetailsViewFactory;
import org.jabref.gui.collab.DatabaseChangeResolver;
import org.jabref.gui.collab.ExternalChangesResolverViewModel;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChangesResolverDialog
extends BaseDialog<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseChangesResolverDialog.class);
    private final Map<DatabaseChange, DatabaseChangeDetailsView> DETAILS_VIEW_CACHE = new HashMap<DatabaseChange, DatabaseChangeDetailsView>();
    @FXML
    private TableView<DatabaseChange> changesTableView;
    @FXML
    private TableColumn<DatabaseChange, String> changeName;
    @FXML
    private Button askUserToResolveChangeButton;
    @FXML
    private BorderPane changeInfoPane;
    private final List<DatabaseChange> changes;
    private final BibDatabaseContext database;
    private ExternalChangesResolverViewModel viewModel;
    private boolean areAllChangesAccepted;
    private boolean areAllChangesDenied;
    @Inject
    private UndoManager undoManager;
    @Inject
    private StateManager stateManager;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private ThemeManager themeManager;
    @Inject
    private BibEntryTypesManager entryTypesManager;
    @Inject
    private TaskExecutor taskExecutor;

    public DatabaseChangesResolverDialog(List<DatabaseChange> changes, BibDatabaseContext database, String dialogTitle) {
        this.changes = changes;
        this.database = database;
        this.setTitle(dialogTitle);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(button -> {
            if (this.viewModel.areAllChangesResolved()) {
                LOGGER.info("External changes are resolved successfully");
                return true;
            }
            LOGGER.info("External changes aren't resolved");
            return false;
        });
    }

    public boolean areAllChangesAccepted() {
        return this.areAllChangesAccepted;
    }

    public boolean areAllChangesDenied() {
        return this.areAllChangesDenied;
    }

    @FXML
    private void initialize() {
        PreviewViewer previewViewer = new PreviewViewer(this.database, this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.taskExecutor);
        DatabaseChangeDetailsViewFactory databaseChangeDetailsViewFactory = new DatabaseChangeDetailsViewFactory(this.database, this.dialogService, this.stateManager, this.themeManager, this.preferencesService, this.entryTypesManager, previewViewer, this.taskExecutor);
        this.viewModel = new ExternalChangesResolverViewModel(this.changes, this.undoManager);
        this.changeName.setCellValueFactory(data -> new SimpleStringProperty(((DatabaseChange)data.getValue()).getName()));
        this.askUserToResolveChangeButton.disableProperty().bind((ObservableValue)this.viewModel.canAskUserToResolveChangeProperty().not());
        this.changesTableView.setItems(this.viewModel.getVisibleChanges());
        this.changesTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.changesTableView.getSelectionModel().selectFirst();
        this.viewModel.selectedChangeProperty().bind((ObservableValue)this.changesTableView.getSelectionModel().selectedItemProperty());
        EasyBind.subscribe(this.viewModel.selectedChangeProperty(), selectedChange -> {
            if (selectedChange != null) {
                DatabaseChangeDetailsView detailsView = this.DETAILS_VIEW_CACHE.computeIfAbsent((DatabaseChange)selectedChange, databaseChangeDetailsViewFactory::create);
                this.changeInfoPane.setCenter((Node)detailsView);
            }
        });
        EasyBind.subscribe((ObservableValue)this.viewModel.areAllChangesResolvedProperty(), isResolved -> {
            if (isResolved.booleanValue()) {
                this.areAllChangesAccepted = this.viewModel.areAllChangesAccepted();
                this.areAllChangesDenied = this.viewModel.areAllChangesDenied();
                this.close();
            }
        });
    }

    @FXML
    public void denyChanges() {
        this.viewModel.denyChange();
    }

    @FXML
    public void acceptChanges() {
        this.viewModel.acceptChange();
    }

    @FXML
    public void askUserToResolveChange() {
        this.viewModel.getSelectedChange().flatMap(DatabaseChange::getExternalChangeResolver).flatMap(DatabaseChangeResolver::askUserToResolveChange).ifPresent(this.viewModel::acceptMergedChange);
    }
}

