/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import org.jabref.gui.cleanup.CleanupPresetPanel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.FilePreferences;

public class CleanupDialog
extends BaseDialog<CleanupPreferences> {
    public CleanupDialog(BibDatabaseContext databaseContext, CleanupPreferences initialPreset, FilePreferences filePreferences) {
        this.setTitle(Localization.lang("Cleanup entries", new Object[0]));
        this.getDialogPane().setPrefSize(600.0, 650.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        CleanupPresetPanel presetPanel = new CleanupPresetPanel(databaseContext, initialPreset, filePreferences);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setContent((Node)presetPanel);
        this.getDialogPane().setContent((Node)scrollPane);
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return presetPanel.getCleanupPreset();
            }
            return null;
        });
    }
}

