/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.citationkeypattern;

import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.citationkeypattern.GenerateCitationKeyAction;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class GenerateCitationKeySingleAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferencesService;
    private final BibEntry entry;
    private final UndoManager undoManager;

    public GenerateCitationKeySingleAction(BibEntry entry, BibDatabaseContext databaseContext, DialogService dialogService, PreferencesService preferencesService, UndoManager undoManager) {
        this.entry = entry;
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.undoManager = undoManager;
        if (preferencesService.getCitationKeyPatternPreferences().shouldAvoidOverwriteCiteKey()) {
            this.executable.bind((ObservableValue)entry.getCiteKeyBinding().isEmpty());
        }
    }

    public void execute() {
        if (!this.entry.hasCitationKey() || GenerateCitationKeyAction.confirmOverwriteKeys(this.dialogService, this.preferencesService)) {
            new CitationKeyGenerator(this.databaseContext, this.preferencesService.getCitationKeyPatternPreferences()).generateAndSetKey(this.entry).ifPresent(change -> this.undoManager.addEdit(new UndoableKeyChange((FieldChange)change)));
        }
    }
}

