/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.DOMBuildingController;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class WebPageBuilder {
    public static final String DEFAULT_MATHJAX_URL = "http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=MML_HTMLorMML-full";
    private final SessionContext sessionContext;
    private final WebPageOutputOptions options;

    public WebPageBuilder(SessionContext sessionContext, WebPageOutputOptions options) {
        this.sessionContext = sessionContext;
        this.options = options;
    }

    public final Document buildWebPage(List<FlowToken> fixedTokens) throws SnuggleParseException {
        String lang;
        Document document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        String[] clientXSLTURLs = this.options.getClientSideXSLTStylesheetURLs();
        if (clientXSLTURLs != null) {
            for (String url : clientXSLTURLs) {
                document.appendChild(document.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + url + "\""));
            }
        }
        Element body = this.createXHTMLElement(document, "body");
        String title = this.options.getTitle();
        if (title != null && this.options.isAddingTitleHeading()) {
            Element titleHeader = this.createXHTMLElement(document, "h1");
            titleHeader.appendChild(document.createTextNode(title));
            body.appendChild(titleHeader);
        }
        DOMBuildingController domBuildingController = new DOMBuildingController(this.sessionContext, this.options);
        domBuildingController.buildDOMSubtree(body, fixedTokens);
        Element head = this.createXHTMLElement(document, "head");
        if (this.options.isAddingMathPlayerImport()) {
            Element object = this.createXHTMLElement(document, "object");
            object.setAttribute("id", "MathPlayer");
            object.setAttribute("classid", "clsid:32F66A20-7614-11D4-BD11-00104BD3F987");
            head.appendChild(object);
            head.appendChild(document.createProcessingInstruction("import", "namespace=\"" + this.options.getMathMLPrefix() + "\" implementation=\"#MathPlayer\" ?"));
        }
        Element meta = this.createXHTMLElement(document, "meta");
        if (this.options.isHtml5()) {
            meta.setAttribute("charset", this.options.getEncoding());
        } else {
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", this.computeMetaContentType());
        }
        head.appendChild(meta);
        meta = this.createXHTMLElement(document, "meta");
        meta.setAttribute("name", "Generator");
        meta.setAttribute("content", "SnuggleTeX");
        head.appendChild(meta);
        Element titleElement = this.createXHTMLElement(document, "title");
        titleElement.appendChild(document.createTextNode(title != null ? title : "SnuggleTeX Generated Page"));
        head.appendChild(titleElement);
        String[] cssStylesheetURLs = this.options.getCSSStylesheetURLs();
        if (cssStylesheetURLs != null) {
            for (String url : cssStylesheetURLs) {
                Element link = this.createXHTMLElement(document, "link");
                link.setAttribute("rel", "stylesheet");
                link.setAttribute("href", url);
                head.appendChild(link);
            }
        }
        if (this.options.isIncludingStyleElement() && !this.options.isInliningCSS()) {
            Element style = this.createXHTMLElement(document, "style");
            style.setAttribute("type", "text/css");
            Properties cssProperties = CSSUtilities.readInlineCSSProperties(this.options);
            style.appendChild(document.createTextNode(CSSUtilities.writeStylesheet(cssProperties)));
            head.appendChild(style);
        }
        if (this.options.isMathJax()) {
            String mathJaxUrl = this.options.getCustomMathJaxUrl();
            if (mathJaxUrl == null) {
                mathJaxUrl = DEFAULT_MATHJAX_URL;
            }
            Element script = this.createXHTMLElement(document, "script");
            script.setAttribute("type", "text/javascript");
            script.setAttribute("src", mathJaxUrl);
            head.appendChild(script);
        }
        Element html = this.createXHTMLElement(document, "html");
        String mathPrefRenderer = this.options.getMathPrefRenderer();
        if (mathPrefRenderer != null) {
            html.setAttributeNS("http://www.w3.org/2002/Math/preference", "pref:renderer", "mathplayer-dl");
        }
        if ((lang = this.options.getLang()) != null) {
            if (this.options.getSerializationMethod() == SerializationMethod.HTML || this.options.getSerializationMethod() == SerializationMethod.STRICTLY_HTML) {
                html.setAttribute("lang", lang);
            } else {
                html.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
            }
        }
        if (this.options.isPrefixingMathML() && this.options.getSerializationMethod() != SerializationMethod.HTML && this.options.getSerializationMethod() != SerializationMethod.STRICTLY_HTML) {
            html.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.options.getMathMLPrefix(), "http://www.w3.org/1998/Math/MathML");
        }
        html.appendChild(head);
        html.appendChild(body);
        document.appendChild(html);
        Object[] stylesheets = this.options.getStylesheets();
        if (!ObjectUtilities.isNullOrEmpty(stylesheets)) {
            for (Object stylesheet : stylesheets) {
                DOMSource input = new DOMSource(document);
                document = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
                try {
                    ((Transformer)stylesheet).transform(input, new DOMResult(document));
                }
                catch (TransformerException e) {
                    throw new SnuggleRuntimeException("Could not apply stylesheet " + stylesheet);
                }
            }
        }
        return document;
    }

    private Element createXHTMLElement(Document document, String elementLocalName) {
        return this.createXHTMLElement(document, elementLocalName, null);
    }

    private Element createXHTMLElement(Document document, String elementLocalName, String content) {
        String qName = this.options.isPrefixingXHTML() ? this.options.getXHTMLPrefix() + ":" + elementLocalName : elementLocalName;
        Element result = document.createElementNS("http://www.w3.org/1999/xhtml", qName);
        if (content != null) {
            result.appendChild(document.createTextNode(content));
        }
        return result;
    }

    public final String buildWebPageString(List<FlowToken> fixedTokens) throws SnuggleParseException {
        Document webPageDocument = this.buildWebPage(fixedTokens);
        StringWriter resultBuilder = new StringWriter();
        if (this.options.isHtml5()) {
            resultBuilder.append("<!DOCTYPE html>\n");
        }
        Transformer serializer = this.createSerializer();
        try {
            serializer.transform(new DOMSource(webPageDocument), new StreamResult(resultBuilder));
        }
        catch (TransformerException e) {
            throw new SnuggleRuntimeException("Could not serialize web page", e);
        }
        return resultBuilder.toString();
    }

    public final void writeWebPage(List<FlowToken> fixedTokens, Object contentTypeSettable, OutputStream outputStream, SnuggleSession.EndOutputAction endOutputOptions) throws SnuggleParseException, IOException {
        if (contentTypeSettable != null) {
            this.setWebPageContentType(contentTypeSettable);
        }
        if (this.options.isHtml5()) {
            OutputStreamWriter doctypeWriter = new OutputStreamWriter(outputStream, this.options.getEncoding());
            doctypeWriter.write("<!DOCTYPE html>\n");
            doctypeWriter.flush();
        }
        Document webPageDocument = this.buildWebPage(fixedTokens);
        Transformer serializer = this.createSerializer();
        try {
            serializer.transform(new DOMSource(webPageDocument), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            throw new SnuggleRuntimeException("Could not serialize web page", e);
        }
        finally {
            if (endOutputOptions == SnuggleSession.EndOutputAction.CLOSE) {
                outputStream.close();
            } else if (endOutputOptions == SnuggleSession.EndOutputAction.FLUSH) {
                outputStream.flush();
            }
        }
    }

    public final void setWebPageContentType(Object contentTypeSettable) {
        try {
            Method setterMethod = contentTypeSettable.getClass().getMethod("setContentType", String.class);
            setterMethod.invoke(contentTypeSettable, this.computeContentTypeHeader());
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not find and call setContentType() on Object " + contentTypeSettable, e);
        }
    }

    private final Transformer createSerializer() {
        StylesheetManager stylesheetManager = this.sessionContext.getStylesheetManager();
        boolean supportsXSLT20 = stylesheetManager.supportsXSLT20();
        Transformer serializer = stylesheetManager.getSerializer(null, this.options);
        serializer.setOutputProperty("media-type", this.options.getContentType());
        Properties outputProperties = serializer.getOutputProperties();
        if (this.options.isHtml5()) {
            outputProperties.remove("doctype-public");
            outputProperties.remove("doctype-system");
        }
        if (this.options.getSerializationMethod() != SerializationMethod.XML) {
            if (supportsXSLT20) {
                serializer.setOutputProperty("include-content-type", "no");
            } else {
                serializer.setOutputProperty("{http://xml.apache.org/xalan}omit-meta-tag", "yes");
            }
        }
        return serializer;
    }

    private String computeContentTypeHeader() {
        String result = this.options.isNoCharsetInContentTypeHeader() ? this.options.getContentType() : this.options.getContentType() + "; charset=" + this.options.getEncoding();
        return result;
    }

    private String computeMetaContentType() {
        return this.options.getContentType() + "; charset=" + this.options.getEncoding();
    }
}

