/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.WriteLineDocTask;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class WriteEnwikiLineDocTask
extends WriteLineDocTask {
    private final PrintWriter categoryLineFileOut;

    public WriteEnwikiLineDocTask(PerfRunData runData) throws Exception {
        super(runData);
        OutputStream out = StreamUtils.outputStream(WriteEnwikiLineDocTask.categoriesLineFile(Paths.get(this.fname, new String[0])));
        this.categoryLineFileOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 65536));
        this.writeHeader(this.categoryLineFileOut);
    }

    public static Path categoriesLineFile(Path f) {
        Path dir = f.toAbsolutePath().getParent();
        String categoriesName = "categories-" + String.valueOf(f.getFileName());
        return dir.resolve(categoriesName);
    }

    @Override
    public void close() throws Exception {
        this.categoryLineFileOut.close();
        super.close();
    }

    @Override
    protected PrintWriter lineFileOut(Document doc) {
        IndexableField titleField = doc.getField("doctitle");
        if (titleField != null && titleField.stringValue().startsWith("Category:")) {
            return this.categoryLineFileOut;
        }
        return super.lineFileOut(doc);
    }
}

