/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public class TimeLimitingKnnCollectorManager
implements KnnCollectorManager {
    private final KnnCollectorManager delegate;
    private final QueryTimeout queryTimeout;

    public TimeLimitingKnnCollectorManager(KnnCollectorManager delegate, QueryTimeout timeout) {
        this.delegate = delegate;
        this.queryTimeout = timeout;
    }

    public QueryTimeout getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, KnnSearchStrategy searchStrategy, LeafReaderContext context) throws IOException {
        KnnCollector collector = this.delegate.newCollector(visitedLimit, searchStrategy, context);
        if (this.queryTimeout == null) {
            return collector;
        }
        return new TimeLimitingKnnCollector(collector);
    }

    class TimeLimitingKnnCollector
    extends KnnCollector.Decorator {
        public TimeLimitingKnnCollector(KnnCollector collector) {
            super(collector);
        }

        @Override
        public boolean earlyTerminated() {
            return TimeLimitingKnnCollectorManager.this.queryTimeout.shouldExit() || super.earlyTerminated();
        }

        @Override
        public TopDocs topDocs() {
            TopDocs docs = super.topDocs();
            TotalHits.Relation relation = TimeLimitingKnnCollectorManager.this.queryTimeout.shouldExit() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : docs.totalHits.relation();
            return new TopDocs(new TotalHits(docs.totalHits.value(), relation), docs.scoreDocs);
        }
    }
}

