import numpy as np
import matplotlib.pyplot as plt
import astropy.units as u

from dust_extinction.parameter_averages import G23

fig, ax = plt.subplots()

# generate the curves and plot them
lam = np.logspace(np.log10(0.0912), np.log10(30.0), num=1000) * u.micron

Rvs = [2.5, 3.1, 4.0, 4.75, 5.5]
for cur_Rv in Rvs:
   ext_model = G23(Rv=cur_Rv)
   ax.plot(lam,ext_model(lam),label='R(V) = ' + str(cur_Rv))

ax.set_xscale('log')
ax.set_yscale('log')

ax.set_xlabel('$\lambda$ [$\mu$m]')
ax.set_ylabel(r'$A(x)/A(V)$')

ax.legend(loc='best')
plt.show()