/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.ui.color.ColorComboBoxRenderer;
import gov.nasa.giss.ui.color.ColorInfo;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Color;
import javax.swing.JComboBox;

public class SimpleColorComboBox
extends JComboBox<ColorInfo> {
    private static final ColorInfo[] BW_ITEMS = new ColorInfo[]{new ColorInfo("black", Color.BLACK), new ColorInfo("white", Color.WHITE)};
    private static final ColorInfo[] GS_ITEMS = new ColorInfo[]{new ColorInfo("black", Color.BLACK), new ColorInfo("dark-gray", Color.DARK_GRAY), new ColorInfo("gray", Color.GRAY), new ColorInfo("light-gray", Color.LIGHT_GRAY), new ColorInfo("pale-gray", Color.decode("0xe0e0e0")), new ColorInfo("smoke-gray", Color.decode("0xf8f8f8")), new ColorInfo("white", Color.WHITE)};
    private static final ColorInfo[] RB_ITEMS = new ColorInfo[]{new ColorInfo("black", Color.BLACK), new ColorInfo("white", Color.WHITE), new ColorInfo("dark-gray", Color.DARK_GRAY), new ColorInfo("gray", Color.GRAY), new ColorInfo("light-gray", Color.LIGHT_GRAY), new ColorInfo("pale-gray", Color.decode("0xe0e0e0")), new ColorInfo("smoke-gray", Color.decode("0xf8f8f8")), new ColorInfo("maroon", Color.decode("0x800000")), new ColorInfo("red", Color.RED), new ColorInfo("orange", Color.ORANGE), new ColorInfo("yellow", Color.YELLOW), new ColorInfo("olive", Color.decode("0x808000")), new ColorInfo("green", Color.decode("0x008000")), new ColorInfo("lime", Color.decode("0x00ff00")), new ColorInfo("cyan", Color.CYAN), new ColorInfo("teal", Color.decode("0x008080")), new ColorInfo("blue", Color.BLUE), new ColorInfo("navy", Color.decode("0x000080")), new ColorInfo("purple", Color.decode("0x800080")), new ColorInfo("magenta", Color.MAGENTA)};
    private final ColorInfo[] items_;

    public SimpleColorComboBox() {
        this(PaletteType.RAINBOW);
    }

    public SimpleColorComboBox(PaletteType ptype) {
        switch (ptype) {
            case BLACK_WHITE: {
                this.items_ = BW_ITEMS;
                break;
            }
            case GRAYSCALE: {
                this.items_ = GS_ITEMS;
                break;
            }
            default: {
                this.items_ = RB_ITEMS;
            }
        }
        this.initMe();
    }

    public SimpleColorComboBox(ColorInfo ... items) {
        this.items_ = items;
        this.initMe();
    }

    private void initMe() {
        for (ColorInfo item : this.items_) {
            this.addItem(item);
        }
        this.setRenderer(new ColorComboBoxRenderer());
        this.setMaximumRowCount(20);
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setSelectedColor(String id) {
        if (id == null) {
            return;
        }
        for (ColorInfo item : this.items_) {
            if (!item.toString().equalsIgnoreCase(id)) continue;
            this.setSelectedItem(item);
        }
    }

    public void setSelectedColor(Color color) {
        if (color == null) {
            return;
        }
        for (ColorInfo item : this.items_) {
            if (!item.getColor().equals(color)) continue;
            this.setSelectedItem(item);
        }
    }

    public Color getSelectedColor() {
        ColorInfo choice = (ColorInfo)this.getSelectedItem();
        if (choice == null) {
            return null;
        }
        return choice.getColor();
    }

    public String getColorID(Color color) {
        if (color == null || this.items_ == null) {
            return "";
        }
        for (ColorInfo item : this.items_) {
            if (!item.getColor().equals(color)) continue;
            return item.toString();
        }
        return "";
    }

    public String getColorName(Color color) {
        if (color == null || this.items_ == null) {
            return "";
        }
        for (ColorInfo item : this.items_) {
            if (!item.getColor().equals(color)) continue;
            return item.getName();
        }
        return "";
    }

    public Color getColorForID(String id) {
        if (id == null || this.items_ == null) {
            return Color.GRAY;
        }
        for (ColorInfo item : this.items_) {
            if (!item.toString().equalsIgnoreCase(id)) continue;
            return item.getColor();
        }
        return Color.GRAY;
    }

    public Color getColorForName(String name) {
        if (name == null || this.items_ == null) {
            return Color.GRAY;
        }
        for (ColorInfo item : this.items_) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return item.getColor();
        }
        return Color.GRAY;
    }
}

