/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.util.PanNcUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class PanUnitsPrefsPanel
extends PanAbstractPrefsPanel {
    private JCheckBox cIsCelsiusCB_;
    private JCheckBox mbIsMillibarCB_;
    private JCheckBox fractionIsPercentCB_;
    private boolean refreshing_;

    public PanUnitsPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel topText = new JLabel("Allow for non-standard variable units strings\u2026");
        this.cIsCelsiusCB_ = new JCheckBox("Treat 'C' as meaning Celsius (not Coulomb)");
        this.mbIsMillibarCB_ = new JCheckBox("Treat 'mb' as meaning millibar");
        this.fractionIsPercentCB_ = new JCheckBox("Treat 'fraction' as meaning percent");
        JLabel bText = new JLabel("Changing unit options may have unpredictable effects in open plots.");
        GuiUtils.setSizeSmall(bText);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Units"));
        this.add(QuickBox.createLeftBox(topText));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.cIsCelsiusCB_));
        this.add(QuickBox.createLeftBox(this.mbIsMillibarCB_));
        this.add(QuickBox.createLeftBox(this.fractionIsPercentCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(bText));
    }

    private void attachListeners() {
        this.cIsCelsiusCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.cIsCelsiusCB_.isSelected();
            prefs_.setBoolean("units:c_is_celsius", bb);
            PanNcUtils.updateAltUnits();
        });
        this.mbIsMillibarCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.mbIsMillibarCB_.isSelected();
            prefs_.setBoolean("units:mb_is_millibar", bb);
            PanNcUtils.updateAltUnits();
        });
        this.fractionIsPercentCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.fractionIsPercentCB_.isSelected();
            prefs_.setBoolean("units:fraction_is_percent", bb);
            PanNcUtils.updateAltUnits();
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.cIsCelsiusCB_.setSelected(prefs_.getBoolean("units:c_is_celsius"));
        this.mbIsMillibarCB_.setSelected(prefs_.getBoolean("units:mb_is_millibar"));
        this.refreshing_ = false;
    }
}

