/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui.table;

import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.text.PrintfFormat;

public class PanArray2DAverageTableModel
extends PanArray2DTableModel {
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");

    public PanArray2DAverageTableModel(NcArray2D array) {
        super(array);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        try {
            int rows = this.array_.getYAxis().getLength();
            if (rows > 105000) {
                return 100001;
            }
            return rows;
        }
        catch (Exception exc) {
            return 0;
        }
    }

    @Override
    public String getColumnName(int col) {
        return "Avg.";
    }

    @Override
    public String getRowName(int row) {
        try {
            int rowx;
            int rows = this.array_.getYAxis().getLength();
            if (row == 100000 && rows > 105000) {
                return "more...";
            }
            int n = rowx = this.flippedBT_ ? rows - 1 - row : row;
            if (this.showCellIndex_) {
                return Integer.toString(rowx + 1);
            }
            double val = this.array_.getYAxis().valueAt(rowx);
            return PFORMAT_10G.sprintfx(val);
        }
        catch (Exception exc) {
            return "";
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            int rows = this.array_.getYAxis().getLength();
            if (row == 100000 && rows > 105000) {
                return "more...";
            }
            int rowx = this.flippedBT_ ? rows - 1 - row : row;
            return this.valFormatter_.sprintfx(this.array_.rowAverageOf(rowx));
        }
        catch (Exception exc) {
            return "ERR";
        }
    }
}

