/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.util.DescribedItem;
import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCLWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static String SYSTEM_EOL = System.getProperty("line.separator");
    private PanPreferences prefs_;
    private PanPlotMeta pmeta_;
    protected PanPlotType ptype_;
    protected PanCombinationType comboType_;
    protected PanData data_;
    protected String[] sources1_;
    protected String[] sources2_;

    public PCLWriter(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
        this.prefs_ = PanPreferences.getSharedInstance();
    }

    public synchronized void exportScript(File f) {
        this.writeSettings(f, false);
    }

    public synchronized void dumpSettings(File f) {
        this.writeSettings(f, true);
    }

    private synchronized void writeSettings(File f, boolean isDump) {
        this.ptype_ = this.pmeta_.getType();
        this.data_ = this.pmeta_.getData();
        String ptypeStr = this.ptype_.getAbbreviation();
        this.comboType_ = PanCombinationType.matching(this.pmeta_.getString("combination"));
        this.sources1_ = this.data_.getArraySource(0);
        this.sources2_ = this.data_.getArraySource(1);
        try {
            PrintWriter writer = new PrintWriter(f);
            this.sources1_[1] = this.sources1_[1].replace("\\", "\\\\");
            String fname = f.getName().replaceAll(" ", "\\\\ ");
            writer.write("// BETA BETA BETA");
            writer.write(SYSTEM_EOL);
            writer.write("// Script parsed by PanoplyCL to create a plot. Usage:");
            writer.write(SYSTEM_EOL);
            writer.write("// java -jar PanoplyCL.jar " + fname);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Note: This script was exported by Panoply " + PanProperties.VERSION_PROPS.getString("version") + ".");
            writer.write(SYSTEM_EOL);
            writer.write("// Many plot option keys are not compatible with Panoply 4.");
            writer.write(SYSTEM_EOL);
            writer.write("// A few may not be compatible with prior Panoply 5 releases.");
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Open a dataset.");
            writer.write(SYSTEM_EOL);
            writer.format("var ncfile1 = panoply.openDataset ( \"%s\" );", this.sources1_[0]);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Select a variable.");
            writer.write(SYSTEM_EOL);
            writer.format("var ncvar1 = ncfile1.getVariable ( \"%s\" );", this.sources1_[1]);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Create the plot.");
            writer.write(SYSTEM_EOL);
            if (this.ptype_ == PanPlotType.GENERAL_CC) {
                PanData2D data2d = (PanData2D)this.data_;
                String xaxname = data2d.getXAxis().getShortName();
                String yaxname = data2d.getYAxis().getShortName();
                if (xaxname == null || yaxname == null) {
                    NcArray2D nca = (NcArray2D)data2d.getArrays()[0];
                    int xindex = nca.getXDimensionIndex();
                    int yindex = nca.getYDimensionIndex();
                    writer.write("// Axes dimensions are not named. Must identify them by index.");
                    writer.write(SYSTEM_EOL);
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, %d, %d );", ptypeStr, xindex + 1, yindex + 1);
                } else {
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, \"%s\", \"%s\" );", PanPlotType.GENERAL_CC.getAbbreviation(), xaxname, yaxname);
                }
            } else if (this.ptype_.isLonLatZonal()) {
                writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1 );", ptypeStr);
            } else if (this.ptype_.isLinePlot()) {
                PanData1D data1d = (PanData1D)this.data_;
                String axname = data1d.getAxisShortName();
                if (axname == null) {
                    NcArray1D nca = (NcArray1D)data1d.getArrays()[0];
                    int xindex = nca.getDimensionIndex();
                    writer.write("// Axis dimension is not named. Must identify it by index.");
                    writer.write(SYSTEM_EOL);
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, %d );", ptypeStr, xindex + 1);
                } else {
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, \"%s\" );", ptypeStr, axname);
                }
            } else {
                writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1 );", ptypeStr);
            }
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            if (this.sources2_ != null) {
                this.sources2_[1] = this.sources2_[1].replace("\\", "\\\\");
                if (this.sources2_[0].equals(this.sources1_[0]) && this.sources2_[1].equals(this.sources1_[1])) {
                    writer.write("// Second variable in combination plot is same as first.");
                    writer.write(SYSTEM_EOL);
                    writer.write("// Also add it to plot in second slot.");
                    writer.write(SYSTEM_EOL);
                    writer.write("myplot.setVariable ( 2, ncvar1 );");
                    writer.write(SYSTEM_EOL);
                } else {
                    if (this.sources2_[0].equals(this.sources1_[0])) {
                        writer.write("// Second variable in combination plot is in same dataset.");
                        writer.write("// Select second variable for combination plot.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncvar2 = ncfile1.getVariable ( \"%s\" );", this.sources2_[1]);
                        writer.write(SYSTEM_EOL);
                    } else {
                        writer.write("// Open dataset containing second var in combination plot.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncfile2 = panoply.openDataset ( \"%s\" );", this.sources2_[0]);
                        writer.write(SYSTEM_EOL);
                        writer.write(SYSTEM_EOL);
                        writer.write("// Select second variable.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncvar2 = ncfile2.getVariable ( \"%s\" );", this.sources2_[1]);
                        writer.write(SYSTEM_EOL);
                    }
                    writer.write(SYSTEM_EOL);
                    writer.write("// Add second var to plot in second slot.");
                    writer.write(SYSTEM_EOL);
                    writer.write("myplot.setVariable ( 2, ncvar2 );");
                    writer.write(SYSTEM_EOL);
                }
                writer.write(SYSTEM_EOL);
                writer.write("// Combination of vars is '" + this.comboType_.getDescription() + "'\n");
                this.writeSetting(writer, "combination");
                writer.write(SYSTEM_EOL);
            }
            this.writeDimensions(writer);
            if (isDump) {
                this.dumpSettings(writer);
            } else {
                writer.write("// Specify plot settings.");
                writer.write(SYSTEM_EOL);
                this.writeSettings(writer);
            }
            this.writeOutput(writer);
            writer.close();
        }
        catch (Exception exc) {
            LOGGER.warn("Failed writing script: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return;
        }
    }

    protected void writeDimensions(PrintWriter writer) {
        for (int i = 0; i < 2; ++i) {
            NcArray nca = this.data_.getArray(i);
            if (nca == null) continue;
            NcDimension[] freeDims = nca.getFreeDimensions();
            for (int j = 0; j < freeDims.length; ++j) {
                if (freeDims[j] == null) continue;
                int offset = nca.getSliceIndex(j);
                writer.format("// Variable #%d (%s), dim %d (%s) -- ", i + 1, nca.getShortName(), j + 1, freeDims[j].getName());
                if (offset == -1) {
                    writer.format("Set to average of %d steps", freeDims[j].getLength());
                    writer.write(SYSTEM_EOL);
                    writer.format("myplot.setVarDimension ( %d, %d, -1 );", i + 1, j + 1);
                    writer.write(SYSTEM_EOL);
                    continue;
                }
                writer.format("Set to step %d of %d", offset + 1, freeDims[j].getLength());
                writer.write(SYSTEM_EOL);
                writer.format("myplot.setVarDimension ( %d, %d, %d );", i + 1, j + 1, offset + 1);
                writer.write(SYSTEM_EOL);
            }
        }
        writer.write(SYSTEM_EOL);
        writer.flush();
    }

    private void writeSettings(PrintWriter writer) {
        this.writeHeaderSettings(writer);
        if (this.ptype_.isLinePlot()) {
            this.writeGridSettings(writer);
            this.writeScaleSettings(writer);
            if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_.isLonLatZonal()) {
                this.writeXAxisSettings(writer);
            } else {
                this.writeYAxisSettings(writer);
            }
            this.writeStrokeSettings(writer);
        } else if (this.ptype_.isLonLatTrajectory()) {
            this.writeScaleSettings(writer);
            this.writeColorbarSettings(writer);
            this.writeMapSettings(writer);
            this.writeGridSettings(writer);
            this.writeSetting(writer, "feature.nanskip");
            this.writeSetting(writer, "feature.background");
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_ID[0]);
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_SIZE[0]);
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_FILL[0]);
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_ID[1]);
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_SIZE[1]);
            this.writeSetting(writer, PanParamKeys.FEATURE_SYMBOL_FILL[1]);
            writer.write(SYSTEM_EOL);
            this.writeStrokeSettings(writer);
        } else {
            this.writeScaleSettings(writer);
            this.writeColorbarSettings(writer);
            if (this.ptype_.isLonLatMap()) {
                this.writeMapSettings(writer);
            } else {
                this.writeXAxisSettings(writer);
                this.writeYAxisSettings(writer);
            }
            this.writeGridSettings(writer);
            this.writeContourSettings(writer);
            this.writeVectorSettings(writer);
        }
        this.writeFootnoteSettings(writer);
        writer.flush();
    }

    private void writeHeaderSettings(PrintWriter writer) {
        this.writeSetting(writer, "size.factor");
        this.writeSetting(writer, "size.width");
        this.writeSetting(writer, "size.height");
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "color.background");
        this.writeSetting(writer, "border.weight");
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "include.title");
        if (!this.ptype_.isLonLatMap()) {
            this.writeSetting(writer, "include.axes");
        }
        this.writeSetting(writer, "include.footnotes");
        this.writeSetting(writer, "include.margins");
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "labels.font");
        this.writeSetting(writer, "labels.super10");
        writer.write(SYSTEM_EOL);
        if (this.pmeta_.getBoolean("include.title")) {
            if (this.pmeta_.getString("title.text").length() > 0) {
                this.writeSetting(writer, "title.text");
                this.writeSetting(writer, "title.size");
            }
            if (this.pmeta_.getString("subtitle.text").length() > 0) {
                this.writeSetting(writer, "subtitle.text");
                this.writeSetting(writer, "subtitle.size");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private void writeScaleSettings(PrintWriter writer) {
        PanAxisMethod method = PanAxisMethod.matching(this.pmeta_.getString("scale.method"));
        if (this.ptype_.isColorContour() || this.ptype_.isFeatureType()) {
            this.writeSetting(writer, "interpolate");
        }
        this.writeSetting(writer, "scale.method");
        if (!"XXX".equals(this.pmeta_.getString("scale.units"))) {
            this.writeSetting(writer, "scale.units");
        }
        if (this.pmeta_.getDouble("scale.coefficient") != 1.0) {
            this.writeSetting(writer, "scale.coefficient");
        }
        if (this.pmeta_.getInt("scale.exponent") != 0) {
            this.writeSetting(writer, "scale.exponent");
        }
        if (!this.pmeta_.getBoolean("scale.autofit")) {
            this.writeSetting(writer, "scale.min");
            this.writeSetting(writer, "scale.max");
        }
        if (method != PanAxisMethod.LOG10) {
            this.writeSetting(writer, "scale.div.major");
            this.writeSetting(writer, "scale.div.minor");
        }
        if (this.pmeta_.getBoolean("include.colorbar")) {
            this.writeSetting(writer, "scale.tick.size");
            this.writeSetting(writer, "scale.tick.format");
        }
        this.writeSetting(writer, "scale.label.custom");
        if (this.pmeta_.getBoolean("scale.label.custom")) {
            this.writeSetting(writer, "scale.label.text");
        }
        this.writeSetting(writer, "scale.label.size");
        writer.write(SYSTEM_EOL);
    }

    private void writeColorbarSettings(PrintWriter writer) {
        if (this.ptype_.isLinePlot()) {
            return;
        }
        this.writeSetting(writer, "include.colorbar");
        this.writeSetting(writer, "colorbar.name");
        this.writeSetting(writer, "colorbar.invalids");
        this.writeSetting(writer, "colorbar.reverse");
        if (this.pmeta_.getBoolean("include.colorbar")) {
            this.writeSetting(writer, "colorbar.location");
            this.writeSetting(writer, "colorbar.length");
            this.writeSetting(writer, "colorbar.border.weight");
            this.writeSetting(writer, "colorbar.tick.length");
            this.writeSetting(writer, "colorbar.outlier.side");
            if (!PanColorbarOutlierSide.NONE.matches(this.pmeta_.getString("colorbar.outlier.side"))) {
                this.writeSetting(writer, "colorbar.outlier.shape");
                this.writeSetting(writer, "colorbar.outlier.gap");
            }
            if (this.ptype_.isColorContour() || this.ptype_.isFeatureType()) {
                this.writeSetting(writer, "colorbar.label.location");
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private void writeGridSettings(PrintWriter writer) {
        this.writeSetting(writer, "grid.weight");
        if (this.pmeta_.getInt("grid.weight") > 0) {
            this.writeSetting(writer, "grid.style");
            this.writeSetting(writer, "grid.color");
        }
        if (this.ptype_.isLonLatMap()) {
            if (this.pmeta_.getInt("grid.weight") > 0) {
                this.writeSetting(writer, "grid.spacing.lon");
                this.writeSetting(writer, "grid.spacing.lat");
                this.writeSetting(writer, "grid.offset.lat");
                this.writeSetting(writer, "grid.lon.pruned");
                this.writeSetting(writer, "grid.label.step");
                this.writeSetting(writer, "grid.label.size");
            }
        } else {
            this.writeSetting(writer, "axes.offset");
            if (!this.pmeta_.getBoolean("axes.offset")) {
                this.writeSetting(writer, "axes.tickmark.weight");
            }
            if (!this.ptype_.isLinePlot()) {
                this.writeSetting(writer, "axes.tickmark.color");
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private void writeXAxisSettings(PrintWriter writer) {
        if (this.ptype_ != PanPlotType.TIME_LAT && this.ptype_ != PanPlotType.TIME_VERT) {
            this.writeSetting(writer, "xaxis.begin");
            this.writeSetting(writer, "xaxis.end");
        }
        if (!PanAxisMethod.LOG10.matches(this.pmeta_.getString("xaxis.method"))) {
            this.writeSetting(writer, "xaxis.div.major");
            this.writeSetting(writer, "xaxis.div.minor");
        }
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.HORZ_LINE) {
            this.writeSetting(writer, "xaxis.method");
            if (!PanAxisMethod.INDEX.matches(this.pmeta_.getString("xaxis.method"))) {
                this.writeSetting(writer, "xaxis.units");
            }
        }
        this.writeSetting(writer, "xaxis.label.size");
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.TIME_LAT || this.ptype_ == PanPlotType.TIME_VERT || this.ptype_.isLinePlot()) {
            this.writeSetting(writer, "xaxis.label.custom");
            if (this.pmeta_.getBoolean("xaxis.label.custom")) {
                this.writeSetting(writer, "xaxis.label.text");
            }
        }
        this.writeSetting(writer, "xaxis.tick.format");
        this.writeSetting(writer, "xaxis.tick.size");
        writer.write(SYSTEM_EOL);
    }

    private void writeYAxisSettings(PrintWriter writer) {
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_.isLinePlot()) {
            this.writeSetting(writer, "yaxis.begin");
            this.writeSetting(writer, "yaxis.end");
        }
        if (!PanAxisMethod.LOG10.matches(this.pmeta_.getString("yaxis.method"))) {
            this.writeSetting(writer, "yaxis.div.major");
            this.writeSetting(writer, "yaxis.div.minor");
        }
        if (this.ptype_ == PanPlotType.GENERAL_CC || this.ptype_ == PanPlotType.LAT_VERT || this.ptype_ == PanPlotType.LON_VERT || this.ptype_.isLinePlot()) {
            this.writeSetting(writer, "yaxis.method");
            if (!PanAxisMethod.INDEX.matches(this.pmeta_.getString("yaxis.method"))) {
                this.writeSetting(writer, "yaxis.units");
            }
        }
        this.writeSetting(writer, "yaxis.label.size");
        if (this.ptype_ != PanPlotType.TIME_LAT) {
            this.writeSetting(writer, "yaxis.label.custom");
            if (this.pmeta_.getBoolean("yaxis.label.custom")) {
                this.writeSetting(writer, "yaxis.label.text");
            }
        }
        this.writeSetting(writer, "yaxis.tick.format");
        this.writeSetting(writer, "yaxis.tick.size");
    }

    private void writeMapSettings(PrintWriter writer) {
        int i;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        this.writeSetting(writer, "proj.name");
        if (proj.isRecenterableLon()) {
            this.writeSetting(writer, "proj.lon0");
        }
        if (proj.isRecenterableLat()) {
            this.writeSetting(writer, "proj.lat0");
        }
        for (i = 0; i < 5; ++i) {
            String k = "proj.xparam." + (i + 1);
            Object s = projmeta.getXParamValue(i);
            if (s == null) continue;
            this.writeSetting(writer, k, s);
        }
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "proj.shading.vis");
        if (this.pmeta_.getBoolean("proj.shading.vis")) {
            this.writeSetting(writer, "proj.shading.opacity");
            this.writeSetting(writer, "proj.subsolar.lon");
            this.writeSetting(writer, "proj.subsolar.lat");
        }
        writer.write(SYSTEM_EOL);
        for (i = 0; i < 3; ++i) {
            MapOverlay overlay = PanResourceUtils.getOverlay(this.pmeta_.getString(PanParamKeys.OVERLAY_NAME[i]));
            if (overlay == null) {
                this.writeSetting(writer, PanParamKeys.OVERLAY_WGT[i], 0);
                continue;
            }
            this.writeSetting(writer, PanParamKeys.OVERLAY_WGT[i]);
            if (this.pmeta_.getInt(PanParamKeys.OVERLAY_WGT[i]) <= 0) continue;
            this.writeSetting(writer, PanParamKeys.OVERLAY_NAME[i]);
            this.writeSetting(writer, PanParamKeys.OVERLAY_COLOR[i]);
            if (overlay instanceof PanMaskOverlay) {
                this.writeSetting(writer, PanParamKeys.OVERLAY_INVERT[i]);
                continue;
            }
            if (!(overlay instanceof ShapefileOverlay)) continue;
            this.writeSetting(writer, PanParamKeys.OVERLAY_STYLE[i]);
            this.writeSetting(writer, PanParamKeys.OVERLAY_SYMBOL_ID[i]);
            this.writeSetting(writer, PanParamKeys.OVERLAY_SYMBOL_SIZE[i]);
        }
        writer.write(SYSTEM_EOL);
        if (this.prefs_.getBoolean("beta:underlays")) {
            boolean alphaEnabled = this.pmeta_.getBoolean("beta.alpha.enabled");
            String uname = this.pmeta_.getString("beta.alpha.underlay");
            int alphaCount = 0;
            if (PanStringUtils.isNoneString(uname)) {
                alphaEnabled = false;
            } else {
                PanAlphaMethod am = PanAlphaMethod.matching(this.pmeta_.getString("beta.alpha.method"));
                alphaCount = am.getAlphaCount();
            }
            this.writeSetting(writer, "beta.alpha.enabled");
            if (alphaEnabled) {
                this.writeSetting(writer, "beta.alpha.method");
                this.writeSetting(writer, "beta.alpha.lavel.1");
                if (alphaCount > 1) {
                    this.writeSetting(writer, "beta.alpha.lavel.2");
                }
                this.writeSetting(writer, "beta.alpha.knockout");
                this.writeSetting(writer, "beta.alpha.underlay");
            }
            writer.write(SYSTEM_EOL);
        }
        if (this.prefs_.getBoolean("beta:numberlays")) {
            this.writeSetting(writer, "beta.numberlay.enabled");
            if (this.pmeta_.getBoolean("beta.numberlay.enabled")) {
                this.writeSetting(writer, "beta.numberlay.lon.spacing");
                this.writeSetting(writer, "beta.numberlay.lat.spacing");
                this.writeSetting(writer, "beta.numberlay.lon.offset");
                this.writeSetting(writer, "beta.numberlay.lat.offset");
                this.writeSetting(writer, "beta.numberlay.size");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private void writeContourSettings(PrintWriter writer) {
        if (this.pmeta_.containsKey("contour.weight")) {
            if (this.pmeta_.getInt("contour.weight") == 0 || "none".equalsIgnoreCase(this.pmeta_.getString("contour.style"))) {
                this.writeSetting(writer, "contour.weight", 0);
            } else {
                this.writeSetting(writer, "contour.weight");
                this.writeSetting(writer, "contour.style");
                this.writeSetting(writer, "contour.color");
                this.writeSetting(writer, "contour.location");
                this.writeSetting(writer, "contour.label.vis");
                this.writeSetting(writer, "contour.label.size");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private void writeVectorSettings(PrintWriter writer) {
        if (this.comboType_ == PanCombinationType.VECTOR && this.pmeta_.containsKey("vector.weight")) {
            if (this.pmeta_.getInt("vector.weight") == 0 || "none".equalsIgnoreCase(this.pmeta_.getString("vector.style"))) {
                this.writeSetting(writer, "vector.weight", 0);
            } else {
                this.writeSetting(writer, "vector.weight");
                this.writeSetting(writer, "vector.style");
                this.writeSetting(writer, "vector.color");
                this.writeSetting(writer, "vector.spacing");
                this.writeSetting(writer, "vector.dir1");
                this.writeSetting(writer, "vector.dir2");
                this.writeSetting(writer, "vector.sample");
                this.writeSetting(writer, "vector.refvalue");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private void writeStrokeSettings(PrintWriter writer) {
        this.writeSetting(writer, "include.strokeinfo");
        this.writeSetting(writer, PanParamKeys.STROKE_WGT[0]);
        this.writeSetting(writer, PanParamKeys.STROKE_COLOR[0]);
        this.writeSetting(writer, PanParamKeys.STROKE_STYLE[0]);
        if (this.pmeta_.getBoolean("include.strokeinfo")) {
            this.writeSetting(writer, PanParamKeys.STROKE_LABEL_CUSTOM[0]);
            if (this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[0])) {
                this.writeSetting(writer, PanParamKeys.STROKE_LABEL_TEXT[0]);
            }
        }
        if (this.sources2_ != null && (this.comboType_ == PanCombinationType.COMPARE || this.ptype_.isLonLatTrajectory())) {
            this.writeSetting(writer, PanParamKeys.STROKE_WGT[1]);
            this.writeSetting(writer, PanParamKeys.STROKE_COLOR[1]);
            this.writeSetting(writer, PanParamKeys.STROKE_STYLE[1]);
            if (this.pmeta_.getBoolean("include.strokeinfo")) {
                this.writeSetting(writer, PanParamKeys.STROKE_LABEL_CUSTOM[1]);
                if (this.pmeta_.getBoolean(PanParamKeys.STROKE_LABEL_CUSTOM[1])) {
                    this.writeSetting(writer, PanParamKeys.STROKE_LABEL_TEXT[1]);
                }
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private void writeFootnoteSettings(PrintWriter writer) {
        if (!this.pmeta_.getBoolean("include.footnotes")) {
            return;
        }
        this.writeSetting(writer, "footnote.size");
        if (this.pmeta_.getString("footnote.left").length() > 0) {
            this.writeSetting(writer, "footnote.left");
        }
        if (this.pmeta_.getString("footnote.right").length() > 0) {
            this.writeSetting(writer, "footnote.right");
        }
        this.writeSetting(writer, "footnote.minmax.vis");
        this.writeSetting(writer, "footnote.minmax.format");
        writer.write(SYSTEM_EOL);
    }

    private void dumpSettings(PrintWriter writer) {
        writer.write("// BDEVO DEVO DEVO");
        writer.write(SYSTEM_EOL);
        writer.write("// Dumping out **ALL** plot settings.");
        writer.write(SYSTEM_EOL);
        String[] message = StringUtils.breakLines(new StringBuilder().append("Order of settings is alphabetic and is not ").append("appropriate for construction of a plot. ").append("Several settings require that others be set first. ").append("Some settings may be specific to GUI versions of ").append("Panoply."), 80);
        for (String msgLine : message) {
            writer.write("// ");
            writer.write(msgLine);
            writer.write(SYSTEM_EOL);
        }
        writer.write(SYSTEM_EOL);
        for (String key : this.pmeta_.keySet()) {
            this.writeSetting(writer, key);
        }
        if (this.ptype_.isLonLatMap()) {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            for (int i = 0; i < 5; ++i) {
                String k = "proj.xparam." + (i + 1);
                Object s = projmeta.getXParamValue(i);
                if (s == null) continue;
                this.writeSetting(writer, k, s);
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private void writeSetting(PrintWriter writer, String pkey) {
        Object pvalue = null;
        if (!this.pmeta_.containsKey(pkey)) {
            LOGGER.warn("'{}' is not a known key for plot type {}", (Object)pkey, (Object)this.ptype_);
            return;
        }
        pvalue = this.pmeta_.get(pkey);
        this.writeSetting(writer, pkey, pvalue);
    }

    private void writeSetting(PrintWriter writer, String pkey, String altkey) {
        Object pvalue = null;
        if (!this.pmeta_.containsKey(pkey)) {
            LOGGER.warn("'{}' is not a known key for plot type {}", (Object)pkey, (Object)this.ptype_);
            return;
        }
        pvalue = this.pmeta_.get(pkey);
        this.writeSetting(writer, altkey, pvalue);
    }

    private void writeSetting(PrintWriter writer, String pkey, Object pvalue) {
        String xpkey = pkey;
        Object svalue = null;
        svalue = pvalue == null ? "NONE" : (pvalue instanceof String || pvalue instanceof AbstractColorTable || pvalue instanceof MapOverlay ? "\"" + pvalue + "\"" : (pvalue instanceof Color ? "\"" + ColorUtils.colorToString((Color)pvalue) + "\"" : (pvalue instanceof Integer || pvalue instanceof Double || pvalue instanceof Float ? pvalue.toString() : (pvalue instanceof Boolean ? pvalue.toString() : (pvalue instanceof DescribedItem ? "\"" + ((DescribedItem)pvalue).name().toString().toUpperCase() + "\"" : "\"" + pvalue.toString() + "\"")))));
        if (xpkey.startsWith("llzonal.")) {
            xpkey = xpkey.replaceFirst("llzonal.", "");
        } else if (pkey.startsWith("lonlat.")) {
            xpkey = xpkey.replaceFirst("lonlat.", "");
        }
        xpkey = xpkey.replaceAll("\\.", "-");
        writer.format("myplot.set ( \"%s\", %s );", xpkey, svalue);
        writer.write(SYSTEM_EOL);
    }

    private void writeOutput(PrintWriter writer) {
        String ucExt = this.prefs_.getString("files:save.image.fext").toUpperCase();
        PanPlotFrame pframe = this.pmeta_.getFrame();
        String pname = pframe != null ? pframe.getTitle().replaceAll("\\s", "_") : "PanoplyPlot";
        writer.write("// Save plot image to disk.");
        writer.write(SYSTEM_EOL);
        if ("PDF".equals(ucExt) || "PS".equals(ucExt)) {
            boolean vectorized = this.prefs_.getBoolean("files:save.pspdf.vectorized");
            PaperSize pps = PaperSize.matching(this.prefs_.getString("files:save.pspdf.paper"));
            writer.format("myplot.saveImage ( \"%s\", \"%s.%s\", %s, \"%s\" );", ucExt, pname, ucExt.toLowerCase(), vectorized, pps.name());
        } else {
            writer.format("myplot.saveImage ( \"%s\", \"%s.%s\" );", ucExt, pname, ucExt.toLowerCase());
        }
        writer.write(SYSTEM_EOL);
    }
}

