/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.task.PanExportCdlTask;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCdlAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CDL_EXT = "cdl";
    private static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-cdl");
    private final PanSourcesFrame parent_;

    public PanExportCdlAction(PanSourcesFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!(node instanceof NcDataNode)) {
            LOGGER.warn("Trying to Export CDL from non-NcDataNode");
            return;
        }
        if (!(node instanceof NcDataset) && !(node instanceof NcVariable)) {
            return;
        }
        String fnameRoot = null;
        if (node instanceof NcDataset) {
            fnameRoot = ((NcDataset)node).getName();
            int lastDot = fnameRoot.lastIndexOf(DOT);
            if (lastDot == 0) {
                return;
            }
            if (lastDot > -1) {
                fnameRoot = fnameRoot.substring(0, lastDot);
            }
        } else {
            fnameRoot = ((NcVariable)node).getName();
        }
        File file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export data as\u2026", fnameRoot, CDL_EXT);
        if (file == null) {
            return;
        }
        PanExportCdlTask task = new PanExportCdlTask(this.parent_, (NcDataNode)node, file);
        this.parent_.addTask(task);
    }
}

