/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class GyorffyG
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Gy\u00f6rffy G";
    public static final int PROPERTIES = 8;
    private static final double C1 = 0.768;
    private static final double C5 = 0.17;
    private static final double MAX_X_OVER_RS = 2.412743157956961;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public GyorffyG(int width, int height) {
        this(width, height, 0, 0);
    }

    public GyorffyG(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.412743157956961, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double x = GyorffyG.getC1C5Term(absPhiRad) * absLambdaRad;
        double y = absPhiRad;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double phiRad = absy * this.invRS_;
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = absx / GyorffyG.getC1C5Term(phiRad);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GyorffyG gyorffyG = this;
        synchronized (gyorffyG) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double phiRad = y * this.invRS_;
                double invC1term = 1.0 / GyorffyG.getC1C5Term(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * invC1term * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getC1C5Term(double phiRad) {
        return 0.768 * (1.0 + 0.17 * phiRad * phiRad) * Math.sqrt(1.0 - Math.pow(0.6366197723675814 * phiRad, 2.0));
    }
}

