/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConicProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class AlbersEqualAreaConic
extends ConicProjection {
    public static final String PROJECTION_NAME = "Albers Equal-Area Conic";
    public static final int PROPERTIES = 0x202010;
    private double termN_;
    private double twoN_;
    private double invN_;
    private double termC_;
    private double rhoC_;

    public AlbersEqualAreaConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public AlbersEqualAreaConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x202010, width, height, xmargin, ymargin);
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double phi1Rad = Math.toRadians(this.phi1_);
        double phi2Rad = Math.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double sinPhiC = Math.sin(this.phiCRad_);
        double sinPhi1 = Math.sin(phi1Rad);
        double sinPhi2 = Math.sin(phi2Rad);
        this.termN_ = 0.5 * (sinPhi1 + sinPhi2);
        this.twoN_ = 2.0 * this.termN_;
        this.invN_ = 1.0 / this.termN_;
        this.termC_ = cosPhi1 * cosPhi1 + this.twoN_ * sinPhi1;
        this.rhoC_ = Math.sqrt(this.termC_ - this.twoN_ * sinPhiC) * this.invN_;
        double dPhi = this.phiHeight_;
        double phiTRad = Math.toRadians(Math.min(90.0, this.phiC_ + 0.5 * dPhi));
        double phiBRad = Math.toRadians(Math.max(-90.0, this.phiC_ - 0.5 * dPhi));
        double sinPhiT = Math.sin(phiTRad);
        double sinPhiB = Math.sin(phiBRad);
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * Math.toRadians(dPhi);
        double rhoT = Math.sqrt(this.termC_ - this.twoN_ * sinPhiT) * this.invN_;
        double rhoB = Math.sqrt(this.termC_ - this.twoN_ * sinPhiB) * this.invN_;
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT2 = rhoT * Math.sin(theta2);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rhoC_ - rhoT * Math.cos(theta1);
        double yT2 = this.rhoC_ - rhoT * Math.cos(theta2);
        double yB1 = this.rhoC_ - rhoB * Math.cos(theta1);
        double yB2 = this.rhoC_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double widthFactor = Math.max(xT2, xB2);
        double heightFactor = Math.max(Math.abs(yT), Math.abs(yB));
        this.setMaxXYOverRS(widthFactor, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double rho = Math.sqrt(this.termC_ - this.twoN_ * Math.sin(phiRad)) * this.invN_;
        double thetaRad = this.termN_ * lambdaRad;
        double x = rho * Math.sin(thetaRad);
        double y = this.rhoC_ - rho * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double rhoCMinusYOverRS = this.rhoC_ - yOverRS;
        double rho = Math.hypot(xOverRS, rhoCMinusYOverRS);
        double nRho = this.termN_ * rho;
        double phiRad = Math.asin(0.5 * (this.termC_ - nRho * nRho) * this.invN_);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rhoCMinusYOverRS) : Math.atan2(xOverRS, rhoCMinusYOverRS);
        double lambdaRad = thetaRad * this.invN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AlbersEqualAreaConic albersEqualAreaConic = this;
        synchronized (albersEqualAreaConic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double rhoCMinusYOverRS = this.rhoC_ - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.hypot(xOverRS, rhoCMinusYOverRS);
                    double nRho = this.termN_ * rho;
                    double sinPhi = 0.5 * (this.termC_ - nRho * nRho) * this.invN_;
                    if (Math.abs(sinPhi) > 1.0) continue;
                    double phiRad = Math.asin(sinPhi);
                    double theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rhoCMinusYOverRS) : Math.atan2(xOverRS, rhoCMinusYOverRS);
                    double lambdaRad = theta * this.invN_;
                    if (lambdaRad > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

