/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataWrapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.StructureDS;

public class NcDataWrapperStructMem
implements NcDataWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StructureDS njstructDS_;
    private String mname_;
    private StructureMembers members_;
    private StructureMembers.Member member_;
    private DataType dtype_;
    private int rank_;
    private int[] shape_;

    public NcDataWrapperStructMem(StructureDS structDS, String mname) {
        this.njstructDS_ = structDS;
        this.mname_ = mname;
        this.members_ = structDS.makeStructureMembers();
        this.member_ = this.members_.findMember(mname);
        this.dtype_ = this.member_.getDataType();
        this.rank_ = structDS.getRank();
        this.shape_ = structDS.getShape();
        Structure sss = this.njstructDS_.select(mname);
        if (sss == null) {
            throw new IllegalArgumentException("Structure has no member named " + mname);
        }
    }

    public void printTests(StringBuilder sb) {
        if (!this.dtype_.isNumeric()) {
            sb.append("Member DataType is not numeric, ").append((Object)this.dtype_).append('\n');
            return;
        }
        try {
            long now = System.currentTimeMillis();
            Variable v = this.njstructDS_.findVariable(this.mname_);
            Array memberArray = v.read();
            sb.append((double)(System.currentTimeMillis() - now) / 1000.0).append(" seconds to extract member array from structure\n\n");
            Index index = memberArray.getIndex();
            int[] shape = memberArray.getShape();
            int iisize = 0;
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    double dd = memberArray.getDouble(index.set(i, j));
                    if (++iisize % 5000000 != 0) continue;
                    LOGGER.debug("idx {}, val {}", (Object)iisize, (Object)dd);
                }
            }
            sb.append((double)(System.currentTimeMillis() - now) / 1000.0).append(" seconds to extract ").append(iisize).append(" member values from array\n\n");
        }
        catch (Exception exc) {
            sb.append("Exception: ").append(exc.getClass().getSimpleName()).append(", ").append(exc.getMessage()).append('\n');
        }
    }

    @Override
    public Object getSource() {
        return this.njstructDS_;
    }

    @Override
    public DataType getDataType() {
        return this.njstructDS_.getDataType();
    }

    @Override
    public String getShortName() {
        return this.mname_;
    }

    @Override
    public String getFullName() {
        return this.njstructDS_.getFullName() + "." + this.mname_;
    }

    @Override
    public String getUnitsStr() {
        return "1";
    }

    @Override
    public int getRank() {
        return this.rank_;
    }

    @Override
    public int[] getShape() {
        return this.shape_;
    }

    @Override
    public Dimension getNjDimension(int index) {
        return this.njstructDS_.getDimension(index);
    }

    @Override
    public CoordinateSystem[] getNjCoordinateSystems() {
        List cslist = this.njstructDS_.getCoordinateSystems();
        if (cslist == null) {
            return new CoordinateSystem[0];
        }
        return cslist.toArray(new CoordinateSystem[0]);
    }

    @Override
    public double valueAt(int idx1) throws IOException {
        return Double.NaN;
    }

    @Override
    public double valueAt(int idx1, int idx2) throws IOException {
        return Double.NaN;
    }
}

