/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanUnderlayComboBox;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.SizeVariant;
import java.awt.Component;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanMainAlphaPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox alphaEnabledCB_;
    private DescribedEnumComboBox alphaMethodCombo_;
    private PanIntSpinner[] alphaLevelSpinners_ = new PanIntSpinner[2];
    private PanCheckBox alphaKnockoutCB_;
    private PanUnderlayComboBox underlayCombo_;
    private boolean refreshing_;

    public PanMainAlphaPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Alpha/Underlay"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a map plot, set\u2026");
        JLabel ulayLabel = new JLabel("Alpha:\u2009");
        this.alphaEnabledCB_ = PanCheckBox.create("Enabled", true);
        JLabel m1Label1 = new JLabel("");
        JLabel m1Label2 = new JLabel("Method:\u2009");
        this.alphaMethodCombo_ = new DescribedEnumComboBox(PanAlphaMethod.class);
        QuickBox m1Box = QuickBox.createLeftBox(m1Label2, this.alphaMethodCombo_);
        JLabel nameLabel = new JLabel("Underlay:\u2009");
        this.underlayCombo_ = new PanUnderlayComboBox(SizeVariant.REGULAR);
        JLabel m2Label2 = new JLabel("Min:\u2009");
        JLabel m2Label3 = new JLabel("%");
        JLabel m2Label4 = new JLabel(", Max:\u2009");
        JLabel m2Label5 = new JLabel("%");
        this.alphaLevelSpinners_[0] = PanIntSpinner.createPct(100);
        this.alphaLevelSpinners_[1] = PanIntSpinner.createPct(100);
        QuickBox m2Box = QuickBox.createLeftBox(m2Label2, this.alphaLevelSpinners_[0], m2Label3, m2Label4, this.alphaLevelSpinners_[1], m2Label5);
        this.alphaKnockoutCB_ = PanCheckBox.create("Invalids are completely transparent", true);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add((Component)ulayLabel, new FGConstraint(0, 1));
        this.add((Component)this.alphaEnabledCB_, new FGConstraint(1, 1));
        this.add((Component)m1Label1, new FGConstraint(0, 2));
        this.add((Component)m1Box, new FGConstraint(1, 2));
        this.add((Component)m2Box, new FGConstraint(1, 3));
        this.add((Component)this.alphaKnockoutCB_, new FGConstraint(1, 4));
        this.add((Component)nameLabel, new FGConstraint(0, 5));
        this.add((Component)this.underlayCombo_, new FGConstraint(1, 5));
    }

    private void attachListeners() {
        this.alphaEnabledCB_.addItemListener(e -> prefs_.setBoolean("plot:beta.alpha.enabled", e.getStateChange() == 1));
        this.alphaMethodCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanAlphaMethod amethod = (PanAlphaMethod)this.alphaMethodCombo_.getSelectedItem();
            prefs_.set("plot:beta.alpha.method", amethod.name());
            this.refresh2();
        });
        this.alphaLevelSpinners_[0].addChangeListener(e -> {
            int ival = this.alphaLevelSpinners_[0].getIntValue();
            prefs_.setInt("plot:beta.alpha.lavel.1", ival);
        });
        this.alphaLevelSpinners_[1].addChangeListener(e -> {
            int ival = this.alphaLevelSpinners_[1].getIntValue();
            prefs_.setInt("plot:beta.alpha.lavel.2", ival);
        });
        this.alphaKnockoutCB_.addItemListener(e -> prefs_.setBoolean("plot:beta.alpha.knockout", e.getStateChange() == 1));
        this.underlayCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setString("plot:beta.alpha.underlay", this.underlayCombo_.getSelectedItem().toString());
            this.refresh2();
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        String uname = prefs_.getString("plot:beta.alpha.underlay");
        this.alphaEnabledCB_.setSelected(prefs_.getBoolean("plot:beta.alpha.enabled"));
        this.underlayCombo_.setSelectedItem(uname);
        this.alphaMethodCombo_.setSelItemMatching("plot:beta.alpha.method");
        this.alphaLevelSpinners_[0].setValue(prefs_.getInt("plot:beta.alpha.lavel.1"));
        this.alphaLevelSpinners_[1].setValue(prefs_.getInt("plot:beta.alpha.lavel.2"));
        this.alphaKnockoutCB_.setSelected(prefs_.getBoolean("plot:beta.alpha.knockout"));
        this.refresh2();
    }

    private void refresh2() {
        if (this.refreshing_) {
            return;
        }
        KMLData oo = this.underlayCombo_.getSelectedUnderlay();
        boolean enabled = oo != null;
        PanAlphaMethod amethod = (PanAlphaMethod)this.alphaMethodCombo_.getSelectedItem();
        int acount = amethod.getAlphaCount();
        this.alphaMethodCombo_.setEnabled(enabled);
        this.alphaLevelSpinners_[0].setEnabled(enabled);
        this.alphaLevelSpinners_[1].setEnabled(enabled && acount > 1);
        this.alphaKnockoutCB_.setEnabled(enabled);
        this.repaint();
    }
}

