/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.FontComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.StringComboBox;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLabelControls
extends PanControlsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private GTextField titleTF_;
    private GTextField subtitleTF_;
    private GTextField lfnTF_;
    private GTextField rfnTF_;
    private PanCheckBox minmaxNoteCB_;
    private StringComboBox minmaxFormatCombo_;
    private FontComboBox fontCombo_;
    private FloatComboBox titleSizeCombo_;
    private FloatComboBox subtitleSizeCombo_;
    private FloatComboBox footnoteSizeCombo_;
    private PanCheckBox super10CB_;
    private boolean refreshing_;

    public PanLabelControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("label-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel titleLabel = new JLabel("Title:\u2009");
        JLabel subtitleLabel = new JLabel("Subtitle:\u2009");
        this.titleTF_ = GTextField.create(this.pmeta_.getString("title.text"), 0);
        this.subtitleTF_ = GTextField.create("", 0);
        this.titleTF_.setName("title.text");
        this.subtitleTF_.setName("subtitle.text");
        QuickBox row1 = QuickBox.createHorizontalBox(titleLabel, this.titleTF_);
        QuickBox row2 = QuickBox.createHorizontalBox(subtitleLabel, this.subtitleTF_);
        JLabel footnotesLabel = new JLabel("Footnotes: ");
        JLabel cfnPadLabel = new JLabel(" ");
        JLabel rfnPadLabel = new JLabel(" ");
        JLabel lfnLabel = new JLabel("Left:\u2009");
        JLabel cfnLabel = new JLabel("Center:\u2009");
        JLabel rfnLabel = new JLabel("Right:\u2009");
        JLabel formatFnLabel = new JLabel(" \u2014  Format:\u2009");
        this.lfnTF_ = GTextField.create("", 30);
        this.rfnTF_ = GTextField.create("", 30);
        this.lfnTF_.setName("footnote.left");
        this.rfnTF_.setName("footnote.right");
        this.minmaxNoteCB_ = PanCheckBox.small("footnote.minmax.vis", "Show data min-max", this.pmeta_.getBoolean("footnote.minmax.vis"));
        this.minmaxFormatCombo_ = StringComboBox.createNumberPformat();
        this.minmaxFormatCombo_.setName("footnote.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as scale ticks", 0);
        QuickBox row3 = QuickBox.createLeftBox(footnotesLabel, lfnLabel, this.lfnTF_);
        QuickBox row4 = QuickBox.createLeftBox(cfnPadLabel, cfnLabel, this.minmaxNoteCB_, formatFnLabel, this.minmaxFormatCombo_);
        QuickBox row5 = QuickBox.createLeftBox(rfnPadLabel, rfnLabel, this.rfnTF_);
        JLabel fontLabel = new JLabel("Typeface:\u2009");
        this.fontCombo_ = FontComboBox.create(SizeVariant.SMALL);
        this.fontCombo_.setName("labels.font");
        QuickBox row6 = QuickBox.createLeftBox(fontLabel, this.fontCombo_);
        JLabel sizeLabel = new JLabel("Sizes:\u2009");
        JLabel titleSizeLabel = new JLabel("Title:\u2009");
        JLabel subtitleSizeLabel = new JLabel("\u2014 Subtitle:\u2009");
        JLabel footnoteSizeLabel = new JLabel("\u2014 Footnotes:\u2009");
        this.titleSizeCombo_ = FloatComboBox.create(8.0f, 40.0f);
        this.subtitleSizeCombo_ = FloatComboBox.create(8.0f, 40.0f);
        this.footnoteSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.titleSizeCombo_.setName("title.size");
        this.subtitleSizeCombo_.setName("subtitle.size");
        this.footnoteSizeCombo_.setName("footnote.size");
        this.titleSizeCombo_.setMaximumSize(this.titleSizeCombo_.getPreferredSize());
        this.subtitleSizeCombo_.setMaximumSize(this.subtitleSizeCombo_.getPreferredSize());
        this.footnoteSizeCombo_.setMaximumSize(this.footnoteSizeCombo_.getPreferredSize());
        QuickBox row7 = QuickBox.createLeftBox(sizeLabel, titleSizeLabel, this.titleSizeCombo_, subtitleSizeLabel, this.subtitleSizeCombo_, footnoteSizeLabel, this.footnoteSizeCombo_);
        JLabel super10Label = new JLabel("Exponents:\u2009");
        this.super10CB_ = PanCheckBox.small("labels.super10", "Replace \"E\" notation with superscripted 10", this.pmeta_.getBoolean("labels.super10"));
        QuickBox row8 = QuickBox.createLeftBox(super10Label, this.super10CB_);
        this.setLayout(new BoxLayout(this, 1));
        this.add(row1);
        this.add(Box.createVerticalStrut(1));
        this.add(row2);
        this.add(Box.createVerticalStrut(1));
        this.add(row3);
        this.add(Box.createVerticalStrut(1));
        this.add(row4);
        this.add(Box.createVerticalStrut(1));
        this.add(row5);
        this.add(Box.createVerticalStrut(1));
        this.add(row6);
        this.add(Box.createVerticalStrut(1));
        this.add(row7);
        this.add(Box.createVerticalStrut(1));
        this.add(row8);
        this.add(Box.createVerticalStrut(4));
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(titleLabel, subtitleLabel, footnotesLabel, cfnPadLabel, rfnPadLabel, fontLabel, sizeLabel, super10Label);
        GuiUtils.matchLabelWidths(lfnLabel, cfnLabel, rfnLabel);
        GuiUtils.matchLabelWidths(fontLabel, sizeLabel, super10Label);
        int tfh = this.titleTF_.getPreferredSize().height;
        Dimension ddpref = new Dimension(480, tfh);
        Dimension ddmax = new Dimension(1000, tfh);
        Dimension ddmin = new Dimension(400, tfh);
        this.titleTF_.setPreferredSize(ddpref);
        this.titleTF_.setMinimumSize(ddmin);
        this.titleTF_.setMaximumSize(ddmax);
        this.subtitleTF_.setPreferredSize(ddpref);
        this.subtitleTF_.setMinimumSize(ddmin);
        this.subtitleTF_.setMaximumSize(ddmax);
        Dimension dd = this.fontCombo_.getPreferredSize();
        if (dd.width > 240) {
            dd.width = 240;
            this.fontCombo_.setPreferredSize(dd);
            this.fontCombo_.setMaximumSize(dd);
        }
        this.titleSizeCombo_.setMaximumSize(null);
        this.subtitleSizeCombo_.setMaximumSize(null);
        this.footnoteSizeCombo_.setMaximumSize(null);
    }

    private void attachListeners() {
        this.titleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.titleTF_, this.pmeta_, "title.text"));
        this.subtitleTF_.getDocument().addDocumentListener(new PanCaptionListener(this.subtitleTF_, this.pmeta_, "subtitle.text"));
        this.lfnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.lfnTF_, this.pmeta_, "footnote.left"));
        this.rfnTF_.getDocument().addDocumentListener(new PanCaptionListener(this.rfnTF_, this.pmeta_, "footnote.right"));
        this.minmaxNoteCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.minmaxNoteCB_.isSelected();
            this.pmeta_.setBoolean("footnote.minmax.vis", bb);
            this.minmaxFormatCombo_.setEnabled(bb);
        });
        this.minmaxFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String format = this.minmaxFormatCombo_.getSelectedString();
            this.pmeta_.setString("footnote.minmax.format", format);
        });
        this.fontCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setString("labels.font", this.fontCombo_.getSelectedItem().toString());
        });
        this.super10CB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.super10CB_.isSelected();
            this.pmeta_.setBoolean("labels.super10", bb);
        });
        this.titleSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setFloat("title.size", this.titleSizeCombo_.getValue());
        });
        this.subtitleSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setFloat("subtitle.size", this.subtitleSizeCombo_.getValue());
        });
        this.footnoteSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.setFloat("footnote.size", this.footnoteSizeCombo_.getValue());
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.refreshTextField(this.titleTF_, "title.text");
        this.refreshTextField(this.subtitleTF_, "subtitle.text");
        this.refreshTextField(this.lfnTF_, "footnote.left");
        this.refreshTextField(this.rfnTF_, "footnote.right");
        this.titleSizeCombo_.setValue(this.pmeta_.getFloat("title.size"));
        this.subtitleSizeCombo_.setValue(this.pmeta_.getFloat("subtitle.size"));
        this.footnoteSizeCombo_.setValue(this.pmeta_.getFloat("footnote.size"));
        this.minmaxNoteCB_.setSelected(this.pmeta_.getBoolean("footnote.minmax.vis"));
        this.minmaxFormatCombo_.setEnabled(this.minmaxNoteCB_.isSelected());
        String mmf = this.pmeta_.getString("footnote.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        this.fontCombo_.setSelectedItem(this.pmeta_.getString("labels.font"));
        this.super10CB_.setSelected(this.pmeta_.getBoolean("labels.super10"));
        this.refreshing_ = false;
    }
}

