/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.panoply.action.PanSaveSettingsAction;
import gov.nasa.giss.panoply.action.PanSaveSettingsToPrefsAction;
import gov.nasa.giss.panoply.menu.PanApplySavedSettingsMenu;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.menu.PanPlotHeightMenu;
import gov.nasa.giss.panoply.menu.PanPlotSizeMenu;
import gov.nasa.giss.panoply.menu.PanPlotWidthMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotSectionID;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.menu.GissMenuItem;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanPlotMenu(PanFrame parent) {
        super(parent, "plot-menu");
        this.add(this.makeItemFromProperties("create-plot", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeCheckBoxItemFromProperties("include-titles", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("include-axes", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("include-colorbar", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("include-strokeinfo", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("include-footnotes", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("include-margins", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("background", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("interpolate", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("reverse-scale", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("center-on-zero", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("fit-scale-to-data", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("fit-scale-to-clut", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("autofit-scale", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("log-scale", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("link-dimensions", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("zoom-plot-in", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("zoom-plot-out", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("swap-xbounds", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("swap-ybounds", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("reset-bounds", null)).setEnabled(false);
        this.addSeparator();
        this.add(new PanPlotSizeMenu(parent));
        this.add(new PanPlotWidthMenu(parent));
        this.add(new PanPlotHeightMenu(parent));
        this.addSeparator();
        AbstractAction a = parent instanceof PanPlotFrame ? new PanSaveSettingsToPrefsAction((PanPlotFrame)parent) : null;
        GissMenuItem jmi = this.makeItemFromProperties("save-settings-to-prefs", a);
        this.add(jmi).setEnabled(a != null);
        if (PanUtils.isDevoSavedSettings()) {
            a = parent instanceof PanPlotFrame ? new PanSaveSettingsAction((PanPlotFrame)parent) : null;
            jmi = this.makeItemFromProperties("save-settings", a);
            this.add(jmi).setEnabled(a != null);
            this.add(new PanApplySavedSettingsMenu(parent));
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame ppf = (PanPlotFrame)this.pframe_;
        boolean animating = PanPlotFrame.isAnimationInProgress();
        if (animating) {
            return;
        }
        PanPlotMeta pmeta = ppf.getMeta();
        if (pmeta == null) {
            return;
        }
        for (PanPlotSectionID sid : PanPlotSectionID.values()) {
            String aid = sid.getActionKey();
            String pid = sid.getParamKey();
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)this.getItemForName(aid);
            Action a = mi.getAction();
            if (a == null) {
                mi.setEnabled(false);
                continue;
            }
            boolean includeSection = pmeta.containsKey(pid);
            a.setEnabled(includeSection);
            if (!includeSection) continue;
            mi.setSelected(pmeta.getBoolean(pid));
        }
        JMenuItem mi = this.getItemForName("background");
        Action a = mi.getAction();
        if (a != null) {
            Color cc = pmeta.getColor("color.background");
            String newtext = cc.equals(Color.BLACK) ? "White Background" : "Black Background";
            mi.setText(newtext);
        }
        mi = (JCheckBoxMenuItem)this.getItemForName("interpolate");
        boolean canInterpolate = pmeta.containsKey("interpolate");
        mi.setEnabled(canInterpolate);
        if (canInterpolate) {
            mi.setSelected(pmeta.getBoolean("interpolate"));
        }
        if ((a = (mi = this.getItemForName("center-on-zero")).getAction()) == null) {
            mi.setEnabled(false);
        } else {
            a.setEnabled(!pmeta.containsKey("scale.autofit") || !pmeta.getBoolean("scale.autofit"));
        }
        mi = (JCheckBoxMenuItem)this.getItemForName("reverse-scale");
        a = mi.getAction();
        if (a == null) {
            mi.setEnabled(false);
        } else if (pmeta.getType().isLinePlot()) {
            a.setEnabled(false);
        } else {
            boolean canReverse = pmeta.containsKey("colorbar.reverse");
            mi.setEnabled(canReverse);
            if (canReverse) {
                mi.setSelected(pmeta.getBoolean("colorbar.reverse"));
            }
        }
        mi = this.getItemForName("fit-scale-to-data");
        a = mi.getAction();
        if (a == null) {
            mi.setEnabled(false);
        } else {
            a.setEnabled(!pmeta.containsKey("scale.autofit") || !pmeta.getBoolean("scale.autofit"));
        }
        mi = this.getItemForName("fit-scale-to-clut");
        a = mi.getAction();
        if (a == null) {
            mi.setEnabled(false);
        } else if (pmeta.getType().isLinePlot()) {
            a.setEnabled(false);
        } else if (pmeta.containsKey("scale.autofit") && pmeta.getBoolean("scale.autofit")) {
            a.setEnabled(false);
        } else {
            PanPlotScaleMeta smeta = pmeta.getScaleMeta();
            AbstractColorTable clut = smeta.getColorTable();
            if (clut instanceof AbstractColorTable) {
                boolean clutHasRange = clut.hasRangeLimits();
                a.setEnabled(clutHasRange);
            } else {
                a.setEnabled(false);
            }
        }
        mi = (JCheckBoxMenuItem)this.getItemForName("autofit-scale");
        a = mi.getAction();
        if (a == null) {
            mi.setEnabled(false);
        } else {
            boolean canAutofit = pmeta.containsKey("scale.autofit");
            a.setEnabled(canAutofit);
            if (canAutofit) {
                mi.setSelected(pmeta.getBoolean("scale.autofit"));
            }
        }
        PanScaleMethod smethod = PanScaleMethod.matching(pmeta.getString("scale.method"));
        boolean islog = smethod == PanScaleMethod.LOG10;
        ((JCheckBoxMenuItem)this.getItemForName("log-scale")).setSelected(islog);
    }
}

