/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.dialog;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanArraySlicePanel;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLinkDimensionsDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame pframe_;
    private PanArraySlicePanel[] spanels_ = new PanArraySlicePanel[2];
    private PanArraySlicer[] selectedSlicers_ = new PanArraySlicer[2];
    private SlicerButton[][] buttons_ = new SlicerButton[2][];
    private JButton makeBtn_;
    private JButton cancelBtn_;
    private boolean success_;

    public PanLinkDimensionsDialog(PanPlotFrame pframe) {
        super(pframe, "Link Variable Dimensions", true);
        this.pframe_ = pframe;
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        int minwidth;
        PanControlsPanel cp = this.pframe_.getControlsPanel(PanPlotControlsID.ARRAYS);
        if (cp == null) {
            LOGGER.warn("Got null for ARRAYS controls panel.");
            return;
        }
        if (!(cp instanceof PanArrayControls)) {
            LOGGER.warn("Got {} for ARRAYS controls panel.", (Object)cp.getClass().getSimpleName());
            return;
        }
        PanArrayControls spanel = (PanArrayControls)cp;
        this.spanels_[0] = spanel.getSlicePanel(0);
        this.spanels_[1] = spanel.getSlicePanel(1);
        this.setResizable(false);
        MultiLineLabel infolabel = new MultiLineLabel("To advance both arrays at the same time using the dimension setting controls, choose one dimension from each to link. Selections must have the same length.", 72, 2);
        JPanel spanel0 = null;
        JPanel spanel1 = null;
        spanel0 = this.makeSlicePanel(0);
        spanel1 = this.makeSlicePanel(1);
        Dimension d0 = spanel0.getPreferredSize();
        Dimension d1 = spanel1.getPreferredSize();
        Dimension d3 = infolabel.getPreferredSize();
        d0.width = minwidth = MathUtils.max(d0.width, d1.width, d3.width);
        d1.width = minwidth;
        spanel0.setPreferredSize(d0);
        spanel0.setMinimumSize(d0);
        spanel1.setPreferredSize(d1);
        spanel1.setMinimumSize(d1);
        spanel0.setAlignmentX(0.0f);
        spanel1.setAlignmentX(0.0f);
        this.cancelBtn_ = new JButton("Cancel");
        this.makeBtn_ = new JButton("Link");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.makeBtn_) : QuickBox.createRightBox(this.makeBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(1, 16, 0, 2);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiUtils.DIALOG_BORDER);
        contentPanel.add((Component)infolabel, new FGConstraint(0, 0));
        contentPanel.add((Component)spanel0, new FGConstraint(0, 8));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 9));
        contentPanel.add((Component)spanel1, new FGConstraint(0, 10));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, 11));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 13, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.makeBtn_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void attachListeners() {
        this.makeBtn_.addActionListener(e -> {
            this.success_ = this.selectedSlicers_[0].isSameLength(this.selectedSlicers_[1]);
            if (!this.success_) {
                JOptionPane.showMessageDialog(this.pframe_, "Selected dimensions must be the same length.");
            }
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public PanArraySlicer[] getSlicers() {
        return this.selectedSlicers_;
    }

    private JPanel makeSlicePanel(int vnum) {
        if (this.spanels_[vnum] == null) {
            return null;
        }
        NcArray ncarray = this.spanels_[vnum].getVariableArray();
        JPanel panel = new JPanel();
        StringBuilder title = new StringBuilder("Array ").append(vnum + 1);
        if (ncarray != null) {
            title.append(": ").append(ncarray.getShortName());
        }
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(title.toString()));
        ButtonGroup bgroup = new ButtonGroup();
        boolean selectedIsSet = false;
        int isize = this.spanels_[vnum].getItemCount();
        this.buttons_[vnum] = new SlicerButton[isize];
        for (int i = 0; i < isize; ++i) {
            PanArraySlicer slicer = this.spanels_[vnum].getSlicer(i);
            if (slicer == null || slicer.getLength() < 2) continue;
            this.buttons_[vnum][i] = new SlicerButton(slicer, vnum);
            if (this.findMatchingSlicer(vnum, slicer) == null) continue;
            if (selectedIsSet) {
                this.buttons_[vnum][i].setSelected(false);
            } else {
                this.buttons_[vnum][i].setSelected(true);
                selectedIsSet = true;
            }
            panel.add(QuickBox.createLeftBox(this.buttons_[vnum][i]));
            bgroup.add(this.buttons_[vnum][i]);
        }
        if (!selectedIsSet) {
            return null;
        }
        return panel;
    }

    private PanArraySlicer findMatchingSlicer(int vnum, PanArraySlicer slicer) {
        if (slicer == null || slicer.getLength() < 2) {
            return null;
        }
        int isize = this.spanels_[1 - vnum].getItemCount();
        for (int i = 0; i < isize; ++i) {
            PanArraySlicer other = this.spanels_[1 - vnum].getSlicer(i);
            if (other == null || other.getLength() <= 1 || !slicer.isSameLength(other)) continue;
            return other;
        }
        return null;
    }

    class SlicerButton
    extends JRadioButton {
        private final PanArraySlicer slicer_;
        private final int vnum_;
        private final int length_;

        SlicerButton(PanArraySlicer slicer, int vnum) {
            this.slicer_ = slicer;
            this.vnum_ = vnum;
            this.length_ = slicer.getLength();
            StringBuilder sb = new StringBuilder();
            sb.append(slicer.getLongName()).append(" (").append(this.length_).append(" steps) ");
            this.setText(sb.toString());
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    this.selectAndLink();
                }
            });
        }

        private void selectAndLink() {
            PanLinkDimensionsDialog.this.selectedSlicers_[this.vnum_] = this.slicer_;
            PanArraySlicer other = PanLinkDimensionsDialog.this.selectedSlicers_[1 - this.vnum_];
            if (this.slicer_.isSameLength(other)) {
                return;
            }
            int isize = PanLinkDimensionsDialog.this.spanels_[1 - this.vnum_].getItemCount();
            for (int i = 0; i < isize; ++i) {
                SlicerButton bb = PanLinkDimensionsDialog.this.buttons_[1 - this.vnum_][i];
                if (bb == null || (other = bb.getSlicer()) == null || !other.isSameLength(this.slicer_)) continue;
                bb.setSelected(true);
                return;
            }
        }

        PanArraySlicer getSlicer() {
            return this.slicer_;
        }

        @Override
        public void setSelected(boolean selected) {
            if (selected) {
                PanLinkDimensionsDialog.this.selectedSlicers_[this.vnum_] = this.slicer_;
            }
            super.setSelected(selected);
        }
    }
}

