/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ProjBooleanComponent
extends ProjParamComponent {
    private static final long serialVersionUID = 181L;
    private final ProjBooleanParameter parameter_;
    private JCheckBox cbox_;

    public ProjBooleanComponent(ProjBooleanParameter xparam) {
        this(xparam, xparam.getDefault());
    }

    public ProjBooleanComponent(ProjBooleanParameter xparam, boolean value) {
        super(xparam);
        this.parameter_ = xparam;
        this.createLayout(value);
    }

    @Override
    public JComponent getComponent() {
        return this.cbox_;
    }

    private void createLayout(boolean value) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.cbox_ = new JCheckBox(this.parameter_.getLabel(), value);
        this.cbox_.setOpaque(false);
        this.add(this.cbox_);
    }

    private void attachListeners() {
        this.cbox_.addItemListener(e -> this.handleChange());
    }

    @Override
    public void reset() {
        this.setSelected(this.parameter_.getDefault());
        this.handleChange();
    }

    @Override
    public String getStringValue() {
        return Boolean.toString(this.isSelected());
    }

    @Override
    public Object getValue() {
        return this.isSelected();
    }

    @Override
    public boolean isEnabled() {
        return this.cbox_.isEnabled();
    }

    @Override
    public void setEnabled(boolean bb) {
        this.cbox_.setEnabled(bb);
    }

    public boolean isSelected() {
        return this.cbox_.isSelected();
    }

    public void setSelected(boolean b) {
        this.cbox_.setSelected(b);
        this.parameter_.setSelected(b);
        this.fireValueChanged();
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        try {
            this.setSelected(Boolean.valueOf(sval));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a Boolean: " + sval);
        }
    }

    @Override
    protected void handleChange() {
        this.parameter_.setSelected(this.cbox_.isSelected());
        this.fireValueChanged();
    }
}

