/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class CantersPolyconicW20
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Canters Polyconic W20";
    public static final int PROPERTIES = 0x200020;
    private static final double C10 = 0.9457;
    private static final double C12 = 0.2962;
    private static final double C32 = 0.042;
    private static final double C14 = -0.1875;
    private static final double CP01 = 0.9836;
    private static final double CP21 = 0.0472;
    private static final double CP41 = -0.0106;
    private static final double CP23 = 0.0929;
    private static final double MAXX_PHI = 29.229999336552154;
    private static final double MAXX_PHIRAD = Math.toRadians(29.229999336552154);
    private static final double MAXY_PHI = 80.91849272174184;
    private static final double MAXY_PHIRAD = Math.toRadians(80.91849272174184);
    private static final double MAX_X_OVER_RS = CantersPolyconicW20.xForLambdaAndPhi(Math.PI, MAXX_PHIRAD);
    private static final double MAX_Y_OVER_RS = CantersPolyconicW20.yForLambdaAndPhi(Math.PI, MAXY_PHIRAD);
    private LonLatRotator rotMatrices_;
    private double lobeXRS_;

    public CantersPolyconicW20(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconicW20(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200020, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat);
        }
    }

    @Override
    protected final void finishScaling() {
        double lobeX = CantersPolyconicW20.xForLambdaAndPhi(Math.PI, Math.toRadians(80.91849272174184));
        this.lobeXRS_ = lobeX * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double lambdaRad = Math.toRadians(llP[0]);
        double phiRad = Math.toRadians(llP[1]);
        double x = CantersPolyconicW20.xForLambdaAndPhi(lambdaRad, phiRad);
        double y = CantersPolyconicW20.yForLambdaAndPhi(lambdaRad, phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad0;
        double yRatio;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = Math.abs(x) * this.invRS_;
        double yOverRS = Math.abs(y) * this.invRS_;
        double xRatio = xOverRS / 2.9710041724998675;
        double lambdaRad0 = yRatio < 0.5 ? 0.9 * xRatio * Math.PI : 1.5707963267948966;
        double[] llRad = this.iterateXY2LLRad(xOverRS, yOverRS, lambdaRad0, phiRad0 = (yRatio = yOverRS / 1.5450352670354603) < 1.0 ? 0.8 * yRatio * 1.5707963267948966 : 1.2566370614359172);
        if (llRad == null) {
            return null;
        }
        double lambdaP = Math.toDegrees(llRad[0]) * Math.signum(x);
        double phiP = Math.toDegrees(llRad[1]) * Math.signum(y);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPolyconicW20 cantersPolyconicW20 = this;
        synchronized (cantersPolyconicW20) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y) * this.invRS_;
                double yRatio = yOverRS / 1.5450352670354603;
                double phiRad0 = yRatio < 1.0 ? 0.8 * yRatio * 1.5707963267948966 : 1.2566370614359172;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double xRatio = xOverRS / 2.9710041724998675;
                    double lambdaRad0 = yRatio < 0.5 ? 0.9 * xRatio * Math.PI : 1.5707963267948966;
                    double[] llRad = this.iterateXY2LLRad(xOverRS, yOverRS, lambdaRad0, phiRad0);
                    if ((llRad == null || Math.abs(llRad[0]) > Math.PI) && x > this.lobeXRS_) continue block3;
                    if (llRad == null) continue;
                    if (y < 0.0) {
                        llRad[1] = -llRad[1];
                    }
                    double[] ll = this.rotMatrices_.inverse(Math.toDegrees(llRad[0]), Math.toDegrees(llRad[1]));
                    this.setInvPoints(ix, iy, ll[0] - this.lambdaC_, ll[1]);
                    ll = this.rotMatrices_.inverse(Math.toDegrees(llRad[0]), -Math.toDegrees(llRad[1]));
                    this.setInvPoints(ix, -iy - 1, ll[0] - this.lambdaC_, ll[1]);
                }
            }
        }
    }

    private double[] iterateXY2LLRad(double xOverRS, double yOverRS, double lambdaRad0, double phiRad0) {
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double f1 = CantersPolyconicW20.xForLambdaAndPhi(lambdaRad, phiRad) - xOverRS;
            double f2 = CantersPolyconicW20.yForLambdaAndPhi(lambdaRad, phiRad) - yOverRS;
            double df1dPhi = CantersPolyconicW20.dxDphi(lambdaRad, phiRad);
            double df1dLambda = CantersPolyconicW20.dxDlambda(lambdaRad, phiRad);
            double df2dPhi = CantersPolyconicW20.dyDphi(lambdaRad, phiRad);
            double df2dLambda = CantersPolyconicW20.dyDlambda(lambdaRad, phiRad);
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (!(Math.abs(dphi) < 1.0E-5 & Math.abs(dlambda) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966 || Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    private static double xForLambdaAndPhi(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double cosPhi = Math.cos(phiRad);
        double eq13 = (0.9457 + (0.2962 + 0.042 * lambdaRad2) * phiRad2 + -0.1875 * phiRad4) * lambdaRad;
        return eq13 * cosPhi;
    }

    private static double dxDlambda(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double cosPhi = Math.cos(phiRad);
        return (0.9457 + (0.2962 + 0.126 * lambdaRad2 + -0.1875 * phiRad2) * phiRad2) * cosPhi;
    }

    private static double dxDphi(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double a = (0.9457 + (0.2962 + 0.042 * lambdaRad2) * phiRad2 + -0.1875 * phiRad4) * lambdaRad;
        double b = cosPhi;
        double daDphi = 2.0 * (0.2962 + 0.042 * lambdaRad2 + -0.375 * phiRad2) * lambdaRad * phiRad;
        double dbDphi = -sinPhi;
        return daDphi * b + a * dbDphi;
    }

    private static double yForLambdaAndPhi(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double cosPhi = Math.cos(phiRad);
        return 0.9836 * phiRad + (0.0472 + -0.0106 * lambdaRad2 + 0.0929 * phiRad2) * lambdaRad2 * phiRad * cosPhi;
    }

    private static double dyDlambda(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double cosPhi = Math.cos(phiRad);
        return 2.0 * (0.0472 + -0.0212 * lambdaRad2 + 0.0929 * phiRad2) * lambdaRad * phiRad * cosPhi;
    }

    private static double dyDphi(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double a = (0.0472 + -0.0106 * lambdaRad2 + 0.0929 * phiRad2) * lambdaRad2 * phiRad;
        double b = cosPhi;
        double daDphi = (0.0472 + -0.0106 * lambdaRad2 + 0.2787 * phiRad2) * lambdaRad2;
        double dbDphi = -sinPhi;
        return 0.9836 + daDphi * b + a * dbDphi;
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda < 1.0E-5) {
            double yy = 1.5450352670354603;
            GraphicUtils.drawLine(g2d, this.outCenterX_, (double)this.outCenterY_ - 1.5450352670354603 * this.rS_, this.outCenterX_, (double)this.outCenterY_ + 1.5450352670354603 * this.rS_);
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBeziers();
        if (curves[0] != null) {
            curves[0].draw(g2d);
        }
        if (curves[1] != null) {
            curves[1].draw(g2d);
        }
    }

    private Bezier[] makeOuterBeziers() {
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            double phiRad = Math.toRadians(jj);
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double cosPhi = Math.cos(phiRad);
            double x = (0.9457 + 0.710723384845753 * phiRad2 + -0.1875 * phiRad4) * Math.PI * cosPhi;
            double y = 0.9836 * phiRad + (-0.0574178066515472 + 0.0929 * phiRad2) * (Math.PI * Math.PI) * phiRad * cosPhi;
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            dotsE[105 - j] = new Point2D.Double(x, y);
            dotsE[105 + j] = new Point2D.Double(x, 2.0 * (double)this.outCenterY_ - y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - x, y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - x, 2.0 * (double)this.outCenterY_ - y);
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }
}

