/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BertinRiviere
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bertin-Rivi\u00e8re";
    public static final int PROPERTIES = 0;
    private static final double CSUBX = 1.68;
    private static final double MAX_X_OVER_RS = 2.3758787847867997;
    private static final double MIN_X_OVER_RS = -2.16976;
    private static final double MAX_Y_OVER_RS = 1.419172468;
    private static final double X_OF_MAX_Y_OVER_RS = 1.04437951096;
    private LonLatRotator rotMatrices_;

    public BertinRiviere(int width, int height) {
        this(width, height, 0, 0);
    }

    public BertinRiviere(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, 2.3758787847867997, 1.419172468);
        super.setCenter(16.5, 42.0);
        this.rotMatrices_ = new LonLatRotator(16.5, 42.0);
        this.finishConstruction();
    }

    @Override
    public final void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        return this.transformLpLp2XYIgnoreMargins(llP[0], llP[1]);
    }

    private Point2D.Double transformLpLp2XYIgnoreMargins(double lonP, double latP) {
        double phiQRad;
        double lambdaQRad = Math.toRadians(lonP);
        if (lambdaQRad + (phiQRad = Math.toRadians(latP)) < -1.4) {
            double e1 = (lambdaQRad - phiQRad + 1.6) * (lambdaQRad + phiQRad + 1.4) / 8.0;
            lambdaQRad += e1;
            phiQRad -= 0.8 * e1 * Math.sin(phiQRad + 1.5707963267948966);
        }
        double halfLambdaQRad = 0.5 * lambdaQRad;
        double cosPhiQ = Math.cos(phiQRad);
        double cosBeta = cosPhiQ * Math.cos(halfLambdaQRad);
        double betaTerm = Math.sqrt(0.5 + 0.5 * cosBeta);
        double x = 0.0;
        double y = 0.0;
        if (betaTerm > 1.0E-5) {
            double sinPhiQ = Math.sin(phiQRad);
            double invBetaTerm = 1.0 / betaTerm;
            x = 1.68 * cosPhiQ * Math.sin(halfLambdaQRad) * invBetaTerm;
            y = sinPhiQ * invBetaTerm;
        }
        double e2 = (1.0 - Math.cos(lambdaQRad * phiQRad)) / 12.0;
        if (y < 0.0) {
            x *= 1.0 + e2;
        } else if (y > 0.0) {
            y *= 1.0 + e2 * x * x / 1.5;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double[] llpRad = this.iterateXY2LpLpRad(x, y);
        if (llpRad == null) {
            return null;
        }
        double lambdaP = Math.toDegrees(llpRad[0]);
        double phiP = Math.toDegrees(llpRad[1]);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BertinRiviere bertinRiviere = this;
        synchronized (bertinRiviere) {
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] llpRad = this.iterateXY2LpLpRad(x, y);
                    if (llpRad == null) {
                        if (!(x * this.invRS_ > 1.04437951096)) continue;
                        continue block3;
                    }
                    double lambdaP = Math.toDegrees(llpRad[0]);
                    double phiP = Math.toDegrees(llpRad[1]);
                    double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
                    this.setInvPoint(ix, iy, ll[0], ll[1]);
                }
            }
        }
    }

    private double[] iterateXY2LpLpRad(double x, double y) {
        double denom;
        double f2;
        double f1;
        double yOverRS = y * this.invRS_;
        double xOverRS = x * this.invRS_;
        if (xOverRS < -2.16976) {
            return null;
        }
        double x2Over1P5 = xOverRS * xOverRS / 1.5;
        double lambdaQRad = 2.9845130209103035 * xOverRS / 2.3758787847867997;
        double phiQRad = 1.0524335389525807 * yOverRS / 1.419172468;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double df2dLambdaQ;
            double df2dPhiQ;
            double df1dLambdaQ;
            double df1dPhiQ;
            double de2termDPhiQ;
            double de2termDLambdaQ;
            double e2term;
            double halfLambdaQRad = 0.5 * lambdaQRad;
            double cosHalfLambdaQ = Math.cos(halfLambdaQRad);
            double sinHalfLambdaQ = Math.sin(halfLambdaQRad);
            double lambdaQPhiQRad = lambdaQRad * phiQRad;
            double cosLambdaQPhiQ = Math.cos(lambdaQPhiQRad);
            double sinLambdaQPhiQ = Math.sin(lambdaQPhiQRad);
            double cosPhiQ = Math.cos(phiQRad);
            double sinPhiQ = Math.sin(phiQRad);
            double cosBeta = cosPhiQ * cosHalfLambdaQ;
            double betaTerm = Math.sqrt(0.5 + 0.5 * cosBeta);
            double invBetaTerm = 1.0 / betaTerm;
            double invBetaTerm3 = invBetaTerm * invBetaTerm * invBetaTerm;
            double e2 = (1.0 - cosLambdaQPhiQ) / 12.0;
            double dcosBetaDLambdaQ = -0.5 * cosPhiQ * sinHalfLambdaQ;
            double dcosBetaDPhiQ = -sinPhiQ * cosHalfLambdaQ;
            double dinvBetaTermDLambdaQ = -0.25 * invBetaTerm3 * dcosBetaDLambdaQ;
            double dinvBetaTermDPhiQ = -0.25 * invBetaTerm3 * dcosBetaDPhiQ;
            double deDLambdaQ = sinLambdaQPhiQ * phiQRad / 12.0;
            double deDPhiQ = sinLambdaQPhiQ * lambdaQRad / 12.0;
            if (y > 0.0) {
                e2term = 1.0 + e2 * x2Over1P5;
                de2termDLambdaQ = x2Over1P5 * deDLambdaQ;
                de2termDPhiQ = x2Over1P5 * deDPhiQ;
                f1 = 1.68 * cosPhiQ * sinHalfLambdaQ * invBetaTerm - xOverRS;
                f2 = sinPhiQ * invBetaTerm * e2term - yOverRS;
                df1dPhiQ = 1.68 * sinHalfLambdaQ * (-sinPhiQ * invBetaTerm + cosPhiQ * dinvBetaTermDPhiQ);
                df1dLambdaQ = 1.68 * cosPhiQ * (0.5 * cosHalfLambdaQ * invBetaTerm + sinHalfLambdaQ * dinvBetaTermDLambdaQ);
                df2dPhiQ = cosPhiQ * invBetaTerm * e2term + sinPhiQ * dinvBetaTermDPhiQ * e2term + sinPhiQ * invBetaTerm * de2termDPhiQ;
                df2dLambdaQ = sinPhiQ * (dinvBetaTermDLambdaQ * e2term + invBetaTerm * de2termDLambdaQ);
            } else {
                e2term = 1.0 + e2;
                de2termDLambdaQ = deDLambdaQ;
                de2termDPhiQ = deDPhiQ;
                f1 = 1.68 * cosPhiQ * sinHalfLambdaQ * invBetaTerm * e2term - xOverRS;
                f2 = sinPhiQ * invBetaTerm - yOverRS;
                df1dPhiQ = 1.68 * sinHalfLambdaQ * (-sinPhiQ * invBetaTerm * e2term + cosPhiQ * dinvBetaTermDPhiQ * e2term + cosPhiQ * invBetaTerm * de2termDPhiQ);
                df1dLambdaQ = 1.68 * cosPhiQ * (0.5 * cosHalfLambdaQ * invBetaTerm * e2term + sinHalfLambdaQ * dinvBetaTermDLambdaQ * e2term + sinHalfLambdaQ * invBetaTerm * de2termDLambdaQ);
                df2dPhiQ = cosPhiQ * invBetaTerm + sinPhiQ * dinvBetaTermDPhiQ;
                df2dLambdaQ = sinPhiQ * dinvBetaTermDLambdaQ;
            }
            denom = df1dPhiQ * df2dLambdaQ - df2dPhiQ * df1dLambdaQ;
            double dphiQRad = (f1 * df2dLambdaQ - f2 * df1dLambdaQ) / denom;
            double dlambdaQRad = (f2 * df1dPhiQ - f1 * df2dPhiQ) / denom;
            phiQRad -= dphiQRad;
            lambdaQRad -= dlambdaQRad;
            if (!(Math.abs(dphiQRad) < 1.0E-5 & Math.abs(dlambdaQRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiQRad) > 1.5707963267948966 || Math.abs(lambdaQRad) > Math.PI) {
            return null;
        }
        if (lambdaQRad + phiQRad >= -1.4) {
            return new double[]{lambdaQRad, phiQRad};
        }
        double lambdaPRad = lambdaQRad;
        double phiPRad = phiQRad;
        found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double e1 = (lambdaPRad - phiPRad + 1.6) * (lambdaPRad + phiPRad + 1.4) / 8.0;
            double de1DphiP = -(lambdaPRad + phiPRad + 1.4) / 8.0 + (lambdaPRad - phiPRad + 1.6) / 8.0;
            double de1DlambdaP = (lambdaPRad + phiPRad + 1.4) / 8.0 + (lambdaPRad - phiPRad + 1.6) / 8.0;
            f1 = lambdaQRad - e1 - lambdaPRad;
            f2 = phiQRad + 0.8 * e1 * Math.sin(phiPRad + 1.5707963267948966) - phiPRad;
            double df1dPhiP = -de1DphiP;
            double df1dLambdaP = -de1DlambdaP - 1.0;
            double df2dPhiP = 0.8 * Math.sin(phiPRad + 1.5707963267948966) * de1DphiP + 0.8 * e1 * Math.cos(phiPRad + 1.5707963267948966) - 1.0;
            double df2dLambdaP = 0.8 * Math.sin(phiPRad + 1.5707963267948966) * de1DlambdaP;
            denom = df1dPhiP * df2dLambdaP - df2dPhiP * df1dLambdaP;
            double dphiPRad = (f1 * df2dLambdaP - f2 * df1dLambdaP) / denom;
            double dlambdaPRad = (f2 * df1dPhiP - f1 * df2dPhiP) / denom;
            phiPRad -= dphiPRad;
            lambdaPRad -= dlambdaPRad;
            if (!(Math.abs(dphiPRad) < 1.0E-5 & Math.abs(dlambdaPRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiPRad) > 1.5707963267948966 || Math.abs(lambdaPRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaPRad, phiPRad};
    }

    private void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBeziers();
        if (curves[0] != null) {
            curves[0].draw(g2d);
        }
        if (curves[1] != null) {
            curves[1].draw(g2d);
        }
    }

    private Bezier[] makeOuterBeziers() {
        double elon = 179.99999;
        double wlon = -179.99999;
        int np = 270;
        double fact = 0.6666666666666666;
        Point2D.Double[] dotsE = new Point2D.Double[271];
        Point2D.Double[] dotsW = new Point2D.Double[271];
        for (int j = 0; j <= 270; ++j) {
            double lat = -90.0 + 0.6666666666666666 * (double)j;
            Point2D.Double edot = this.transformLpLp2XYIgnoreMargins(179.99999, lat);
            Point2D.Double wdot = this.transformLpLp2XYIgnoreMargins(-179.99999, lat);
            dotsE[j] = edot;
            dotsW[j] = wdot;
        }
        return new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
    }
}

