/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.proj.AbstractProjection;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Class<? extends AbstractProjection> pclass_;
    private final String cname_;
    private String pname_;
    private String sname_;

    ProjectionInfo(Class<? extends AbstractProjection> pclass) {
        this.pclass_ = pclass;
        this.cname_ = pclass.getSimpleName();
        try {
            Field nameField = pclass.getField("PROJECTION_NAME");
            this.pname_ = nameField.get(null).toString();
            this.sname_ = Normalizer.normalize(this.pname_, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
        }
        catch (Exception exc) {
            LOGGER.error("Couldn't set up projection {}", (Object)pclass);
        }
    }

    String getName() {
        return this.pname_;
    }

    String getClassName() {
        return this.cname_;
    }

    String getNormalizedName() {
        return this.sname_;
    }

    Class<? extends AbstractProjection> getPClass() {
        return this.pclass_;
    }

    boolean hasProperty(int prop) {
        try {
            Field field = this.getPClass().getField("PROPERTIES");
            return ((Integer)field.get(null) & prop) != 0;
        }
        catch (Exception exc) {
            LOGGER.error("Property test failed on exception; returning false");
            return false;
        }
    }
}

