/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.ColorTableFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Objects;

public class ColorTableFilenameFilter
implements FilenameFilter {
    public static final String DOT = ".";

    @Override
    public boolean accept(File dir, String name) {
        if (ColorTableFilenameFilter.isColorTableName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isColorTableName(File f) {
        Objects.requireNonNull(f, "File cannot be null.");
        return ColorTableFilenameFilter.isColorTableName(f.getName());
    }

    public static boolean isColorTableName(String fname) {
        Objects.requireNonNull(fname, "File name cannot be null.");
        String lcname = fname.toLowerCase();
        for (String ext : ColorTableFactory.getValidExtensions()) {
            String dotext = DOT + ext.toLowerCase();
            if (!lcname.endsWith(dotext)) continue;
            return true;
        }
        return false;
    }

    public static String[] getExtensions() {
        return ColorTableFactory.getValidExtensions();
    }
}

