/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class SplitMix64
extends LongProvider {
    private long state;

    public SplitMix64(long seed) {
        this.state = seed;
    }

    public SplitMix64(Long seed) {
        this.setSeedInternal(seed);
    }

    private void setSeedInternal(Long seed) {
        this.state = seed;
    }

    @Override
    public long next() {
        long z = this.state += -7046029254386353131L;
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(this.state), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 8);
        this.state = NumberFactory.makeLong(c[0]);
        super.setStateInternal(c[1]);
    }
}

