/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataTable;

public class DataColumn {
    private boolean readOnly;
    private DataTable table;
    private String columnName;
    private String captionName;
    private int columnIndex;
    private DataType dataType;
    private String format;
    private boolean joined = false;

    public DataColumn() {
        this("default1");
    }

    public DataColumn(DataType dataType) {
        this("default1", dataType);
    }

    public DataColumn(String columnName) {
        this(columnName, DataType.INT);
    }

    public DataColumn(String columnName, DataType dataType) {
        this.dataType = dataType;
        this.columnName = columnName;
        if (this.dataType == DataType.DATE) {
            this.format = "YYYYMMddHH";
        }
    }

    public DataColumn(String columnName, DataType dataType, String format) {
        this.dataType = dataType;
        this.columnName = columnName;
        this.format = format;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getCaptionName() {
        return this.captionName;
    }

    public void setCaptionName(String captionName) {
        this.captionName = captionName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void setJoined(boolean value) {
        this.joined = value;
    }

    public DataTable getTable() {
        return this.table;
    }

    public void setTable(DataTable table) {
        this.table = table;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
        if (dataType == DataType.DATE) {
            this.format = "YYYYMMddHH";
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public String getDataTypeName() {
        return this.dataType.toString();
    }

    public Object convertTo(Object value) {
        if (value == null) {
            switch (this.dataType) {
                case INT: {
                    return Integer.MIN_VALUE;
                }
                case LONG: {
                    return Long.MIN_VALUE;
                }
                case FLOAT: {
                    return Float.valueOf(Float.NaN);
                }
                case DOUBLE: {
                    return Double.NaN;
                }
                case BOOLEAN: {
                    return false;
                }
                case STRING: {
                    return "";
                }
            }
            return value;
        }
        switch (this.dataType) {
            case INT: {
                if (value instanceof Integer) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return Integer.MIN_VALUE;
                }
                return Integer.valueOf(vStr);
            }
            case LONG: {
                if (value instanceof Long) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return Long.MIN_VALUE;
                }
                return Long.valueOf(vStr);
            }
            case DOUBLE: {
                if (value instanceof Double) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Double.NaN;
                }
                return Double.valueOf(vStr);
            }
            case FLOAT: {
                if (value instanceof Float) break;
                String vStr = value.toString();
                if (vStr.isEmpty() || vStr.equalsIgnoreCase("nan")) {
                    return Float.valueOf(Float.NaN);
                }
                try {
                    float v = Float.valueOf(vStr).floatValue();
                    return Float.valueOf(v);
                }
                catch (Exception e) {
                    return Float.valueOf(Float.NaN);
                }
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return false;
                }
                return Boolean.valueOf(vStr);
            }
            case DATE: {
                if (value instanceof LocalDateTime) break;
                String vStr = value.toString();
                if (vStr.isEmpty()) {
                    return null;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.format);
                return JDateUtil.parseDateTime((String)vStr, (DateTimeFormatter)formatter);
            }
        }
        return value;
    }

    public String toString() {
        return this.columnName;
    }

    public Object clone() {
        DataColumn col = new DataColumn();
        col.captionName = this.captionName;
        col.columnIndex = this.columnIndex;
        col.columnName = this.columnName;
        col.dataType = this.dataType;
        col.readOnly = this.readOnly;
        col.format = this.format;
        return col;
    }
}

